/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.Executable;
import sf.util.SchemaCrawlerLogger;

abstract class BaseCommandChainExecutable
extends BaseStagedExecutable {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)BaseCommandChainExecutable.class.getName());
    private final List<Executable> executables;
    protected final CommandRegistry commandRegistry = new CommandRegistry();

    protected BaseCommandChainExecutable(String command) throws SchemaCrawlerException {
        super(command);
        this.executables = new ArrayList<Executable>();
    }

    public final Executable addNext(Executable executable) {
        if (executable != null) {
            this.executables.add(executable);
        }
        return executable;
    }

    protected final void executeChain(Catalog catalog, Connection connection) throws Exception {
        if (this.executables.isEmpty()) {
            LOGGER.log(Level.INFO, "No commands to execute");
            return;
        }
        for (Executable executable : this.executables) {
            if (!(executable instanceof BaseStagedExecutable)) continue;
            ((BaseStagedExecutable)executable).executeOn(catalog, connection);
        }
    }
}

