/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.io.Serializable;
import sf.util.Utility;

public final class DatabaseServerType
implements Serializable {
    private static final long serialVersionUID = 2160456864554076419L;
    public static final DatabaseServerType UNKNOWN = new DatabaseServerType();
    private final String databaseSystemIdentifier;
    private final String databaseSystemName;

    public DatabaseServerType(String databaseSystemIdentifier, String databaseSystemName) {
        if (Utility.isBlank((CharSequence)databaseSystemIdentifier)) {
            throw new IllegalArgumentException("No database system identifier provided");
        }
        this.databaseSystemIdentifier = databaseSystemIdentifier;
        if (Utility.isBlank((CharSequence)databaseSystemName)) {
            throw new IllegalArgumentException("No database system name provided");
        }
        this.databaseSystemName = databaseSystemName;
    }

    private DatabaseServerType() {
        this.databaseSystemIdentifier = null;
        this.databaseSystemName = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseServerType other = (DatabaseServerType)obj;
        return !(this.databaseSystemIdentifier == null ? other.databaseSystemIdentifier != null : !this.databaseSystemIdentifier.equals(other.databaseSystemIdentifier));
    }

    public String getDatabaseSystemIdentifier() {
        return this.databaseSystemIdentifier;
    }

    public String getDatabaseSystemName() {
        return this.databaseSystemName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.databaseSystemIdentifier == null ? 0 : this.databaseSystemIdentifier.hashCode());
        return result;
    }

    public boolean isUnknownDatabaseSystem() {
        return Utility.isBlank((CharSequence)this.databaseSystemIdentifier);
    }

    public String toString() {
        if (this.isUnknownDatabaseSystem()) {
            return "";
        }
        return String.format("%s - %s", this.databaseSystemIdentifier, this.databaseSystemName);
    }
}

