/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import com.annimon.stream.function.Predicate;
import java.sql.Connection;
import java.sql.SQLException;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.IncludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.utility.Identifiers;
import sf.util.Utility;

public class DatabaseObjectFullNameFilter<D extends DatabaseObject>
implements Predicate<D> {
    private final Identifiers identifiers;
    private final InclusionRule databaseObjectInclusionRule;

    public static <D extends DatabaseObject> Builder<D> databaseObjectFullNameFilter() {
        return new Builder();
    }

    private DatabaseObjectFullNameFilter(Builder<D> builder) {
        this.identifiers = ((Builder)builder).identifiersBuilder.build();
        this.databaseObjectInclusionRule = ((Builder)builder).databaseObjectInclusionRule;
    }

    public boolean test(D databaseObject) {
        if (databaseObject == null) {
            return false;
        }
        boolean include = this.databaseObjectInclusionRule.test(this.getUnqotedFullName(databaseObject));
        return include;
    }

    private String getUnqotedFullName(D databaseObject) {
        Schema schema = databaseObject.getSchema();
        String unquotedName = this.identifiers.unquotedName(databaseObject.getName());
        String unquotedSchemaName = this.identifiers.unquotedName(schema.getName());
        String unquotedCatalogName = this.identifiers.unquotedName(schema.getCatalogName());
        StringBuilder buffer = new StringBuilder(64);
        String schemaFullName = new SchemaReference(unquotedCatalogName, unquotedSchemaName).getFullName();
        if (!Utility.isBlank(schemaFullName)) {
            buffer.append(schemaFullName).append('.');
        }
        if (!Utility.isBlank(unquotedName)) {
            buffer.append(unquotedName);
        }
        return buffer.toString();
    }

    public static class Builder<D extends DatabaseObject> {
        private final Identifiers.Builder identifiersBuilder = Identifiers.identifiers();
        private InclusionRule databaseObjectInclusionRule = new IncludeAll();

        private Builder() {
        }

        public DatabaseObjectFullNameFilter<D> build() {
            return new DatabaseObjectFullNameFilter(this);
        }

        public Builder<D> withConnection(Connection connection) throws SQLException {
            this.identifiersBuilder.withConnection(connection);
            return this;
        }

        public Builder<D> withIdentifierQuoteString(String identifierQuoteString) {
            this.identifiersBuilder.withIdentifierQuoteString(identifierQuoteString);
            return this;
        }

        public Builder<D> withInclusionRule(InclusionRule databaseObjectInclusionRule) {
            this.databaseObjectInclusionRule = databaseObjectInclusionRule != null ? databaseObjectInclusionRule : new IncludeAll();
            return this;
        }
    }
}

