/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Map;
import java.util.logging.Level;
import schemacrawler.schemacrawler.BaseDatabaseConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.UserCredentials;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class DatabaseConfigConnectionOptions
extends BaseDatabaseConnectionOptions {
    private static final long serialVersionUID = -8141436553988174836L;
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(DatabaseConfigConnectionOptions.class.getName());
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String DATABASE = "database";
    private static final String URLX = "urlx";

    public DatabaseConfigConnectionOptions(UserCredentials userCredentials, Map<String, String> properties) throws SchemaCrawlerException {
        super(userCredentials, properties);
    }

    public String getDatabase() {
        return (String)this.connectionProperties.get(DATABASE);
    }

    public String getHost() {
        return (String)this.connectionProperties.get(HOST);
    }

    public int getPort() {
        String port = (String)this.connectionProperties.get(PORT);
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot connect to port, " + port);
        }
    }

    public String getUrlX() {
        return (String)this.connectionProperties.get(URLX);
    }

    public void setDatabase(String database) {
        if (database != null) {
            this.connectionProperties.put(DATABASE, database);
        }
    }

    public void setHost(String host) {
        if (!Utility.isBlank(host)) {
            this.connectionProperties.put(HOST, host);
        }
    }

    public void setPort(int port) {
        if (port > 0) {
            this.connectionProperties.put(PORT, String.valueOf(port));
        } else {
            LOGGER.log(Level.WARNING, new StringFormat("Cannot connect to port, %d", port));
        }
    }
}

