/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.annimon.stream.Optional;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableType;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.utility.Query;
import schemacrawler.utility.TableTypes;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

final class TableRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableRetriever.class.getName());

    TableRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveTables(NamedObjectList<SchemaReference> schemas, String tableNamePattern, Collection<String> tableTypes, InclusionRule tableInclusionRule) throws SQLException {
        Objects.requireNonNull(schemas);
        InclusionRuleFilter<Table> tableFilter = new InclusionRuleFilter<Table>(tableInclusionRule, false);
        if (tableFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving tables, since this was not requested");
            return;
        }
        MetadataRetrievalStrategy tableRetrievalStrategy = this.getRetrieverConnection().getTableRetrievalStrategy();
        switch (tableRetrievalStrategy) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving tables, using fast data dictionary retrieval");
                this.retrieveTablesFromDataDictionary(schemas, tableNamePattern, tableTypes, tableFilter);
                break;
            }
            case metadata_all: {
                LOGGER.log(Level.INFO, "Retrieving tables, using fast meta-data retrieval");
                this.retrieveTablesFromMetadataForAllTables(schemas, tableNamePattern, tableTypes, tableFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving tables");
                this.retrieveTablesFromMetadata(schemas, tableNamePattern, tableTypes, tableFilter);
                break;
            }
        }
    }

    private void createTable(MetadataResultSet results, NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Table> tableFilter, TableTypes supportedTableTypes) {
        MutableTable table;
        String columnCatalogName = this.nameQuotedName(results.getString("TABLE_CAT"));
        String schemaName = this.nameQuotedName(results.getString("TABLE_SCHEM"));
        String tableName = this.nameQuotedName(results.getString("TABLE_NAME"));
        LOGGER.log(Level.FINE, new StringFormat("Retrieving table <%s.%s.%s>", columnCatalogName, schemaName, tableName));
        String tableTypeString = results.getString("TABLE_TYPE");
        String remarks = results.getString("REMARKS");
        Optional<SchemaReference> optionalSchema = schemas.lookup(new SchemaReference(columnCatalogName, schemaName).toString());
        if (!optionalSchema.isPresent()) {
            return;
        }
        Schema schema = (Schema)optionalSchema.get();
        TableType tableType = (TableType)supportedTableTypes.lookupTableType(tableTypeString).orElse((Object)TableType.UNKNOWN);
        if (tableType.equals(TableType.UNKNOWN)) {
            LOGGER.log(Level.FINE, new StringFormat("Unknown table type <%s> for <%s.%s>", tableTypeString, schema, tableName));
        }
        if (tableFilter.test(table = tableType.isView() ? new MutableView(schema, tableName) : new MutableTable(schema, tableName))) {
            table.setTableType(tableType);
            table.setRemarks(remarks);
            this.catalog.addTable(table);
        }
    }

    private void retrieveTablesFromDataDictionary(NamedObjectList<SchemaReference> schemas, String tableNamePattern, Collection<String> tableTypes, InclusionRuleFilter<Table> tableFilter) throws SchemaCrawlerSQLException, SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasTablesSql()) {
            throw new SchemaCrawlerSQLException("No tables SQL provided", null);
        }
        Query tablesSql = informationSchemaViews.getTablesSql();
        Connection connection = this.getDatabaseConnection();
        TableTypes supportedTableTypes = this.getRetrieverConnection().getTableTypes();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tablesSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveTablesFromDataDictionary");
            while (results.next()) {
                this.createTable(results, schemas, tableFilter, supportedTableTypes);
            }
        }
    }

    private void retrieveTablesFromMetadata(NamedObjectList<SchemaReference> schemas, String tableNamePattern, Collection<String> tableTypes, InclusionRuleFilter<Table> tableFilter) throws SQLException {
        for (Schema schema : schemas) {
            LOGGER.log(Level.INFO, new StringFormat("Retrieving tables for schema <%s>", schema));
            TableTypes supportedTableTypes = this.getRetrieverConnection().getTableTypes();
            String[] filteredTableTypes = supportedTableTypes.filterUnknown(tableTypes);
            LOGGER.log(Level.FINER, new StringFormat("Retrieving table types <%s>", filteredTableTypes == null ? "<<all>>" : Arrays.asList(filteredTableTypes)));
            String catalogName = schema.getCatalogName();
            String schemaName = schema.getName();
            MetadataResultSet results = new MetadataResultSet(this.getMetaData().getTables(this.unquotedName(catalogName), this.unquotedName(schemaName), tableNamePattern, filteredTableTypes));
            Throwable throwable = null;
            try {
                results.setDescription("retrieveTables");
                while (results.next()) {
                    this.createTable(results, schemas, tableFilter, supportedTableTypes);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (results == null) continue;
                if (throwable != null) {
                    try {
                        results.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                results.close();
            }
        }
    }

    private void retrieveTablesFromMetadataForAllTables(NamedObjectList<SchemaReference> schemas, String tableNamePattern, Collection<String> tableTypes, InclusionRuleFilter<Table> tableFilter) throws SQLException {
        TableTypes supportedTableTypes = this.getRetrieverConnection().getTableTypes();
        String[] filteredTableTypes = supportedTableTypes.filterUnknown(tableTypes);
        LOGGER.log(Level.FINER, new StringFormat("Retrieving table types <%s>", filteredTableTypes == null ? "<<all>>" : Arrays.asList(filteredTableTypes)));
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getTables(null, null, tableNamePattern, filteredTableTypes));){
            results.setDescription("retrieveTables");
            while (results.next()) {
                this.createTable(results, schemas, tableFilter, supportedTableTypes);
            }
        }
    }
}

