/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.annimon.stream.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import schemacrawler.crawl.MutableProcedureColumn;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.ProcedureColumn;
import schemacrawler.schema.ProcedureReturnType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;

final class MutableProcedure
extends MutableRoutine
implements Procedure {
    private static final long serialVersionUID = 3906925686089134130L;
    private ProcedureReturnType returnType;
    private final NamedObjectList<MutableProcedureColumn> columns = new NamedObjectList();

    MutableProcedure(Schema schema, String name) {
        super(schema, name);
        this.returnType = ProcedureReturnType.unknown;
    }

    @Override
    public List<ProcedureColumn> getColumns() {
        return new ArrayList<ProcedureColumn>(this.columns.values());
    }

    @Override
    public ProcedureReturnType getReturnType() {
        return this.returnType;
    }

    @Override
    public RoutineType getRoutineType() {
        return RoutineType.procedure;
    }

    public Optional<MutableProcedureColumn> lookupColumn(String name) {
        return this.columns.lookup(this, name);
    }

    void addColumn(MutableProcedureColumn column) {
        this.columns.add(column);
    }

    void setReturnType(ProcedureReturnType returnType) {
        this.returnType = Objects.requireNonNull(returnType, "Null procedure return type");
    }
}

