/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.DatabaseObjectReference;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.DependantObject;
import sf.util.Utility;

abstract class AbstractDependantObject<D extends DatabaseObject>
extends AbstractDatabaseObject
implements DependantObject<D> {
    private static final long serialVersionUID = -4327208866052082457L;
    private final DatabaseObjectReference<D> parent;

    AbstractDependantObject(DatabaseObjectReference<D> parent, String name) {
        super(Objects.requireNonNull(parent, "Parent of dependent object not provided").get().getSchema(), name);
        this.parent = parent;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        DependantObject other = (DependantObject)obj;
        return !(this.parent == null ? other.getParent() != null : !this.parent.equals(other.getParent()));
    }

    @Override
    public String getFullName() {
        String quotedName;
        String parentFullName;
        StringBuilder buffer = new StringBuilder(64);
        if (this.parent != null && !Utility.isBlank(parentFullName = this.parent.get().getFullName())) {
            buffer.append(parentFullName).append('.');
        }
        if (!Utility.isBlank(quotedName = this.getName())) {
            buffer.append(quotedName);
        }
        return buffer.toString();
    }

    @Override
    public final D getParent() {
        return this.parent.get();
    }

    @Override
    public final String getShortName() {
        String quotedName;
        String parentName;
        StringBuilder buffer = new StringBuilder(64);
        if (this.parent != null && !Utility.isBlank(parentName = this.parent.get().getName())) {
            buffer.append(parentName).append('.');
        }
        if (!Utility.isBlank(quotedName = this.getName())) {
            buffer.append(quotedName);
        }
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean isParentPartial() {
        return this.parent.isPartialDatabaseObjectReference();
    }
}

