/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.chinook_database;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Objects;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.sqlite.JDBC;
import us.fatehi.chinook_database.ChinookDatabaseUtils;
import us.fatehi.chinook_database.DatabaseType;
import us.fatehi.chinook_database.Version;

public class SQLiteGenerator {
    public static Path createSQLiteChinookDatabase() throws IOException, SQLException {
        return SQLiteGenerator.createSQLiteChinookDatabase(Files.createTempFile("chinook-database", ".db", new FileAttribute[0]));
    }

    public static Path createSQLiteChinookDatabase(Path chinookDatabasePath) throws SQLException {
        Objects.requireNonNull(chinookDatabasePath, "No database path provided");
        SimpleDriverDataSource dataSource = new SimpleDriverDataSource((Driver)new JDBC(), "jdbc:sqlite:" + chinookDatabasePath);
        ChinookDatabaseUtils.createChinookDatabase(DatabaseType.sqlite, dataSource.getConnection());
        return chinookDatabasePath;
    }

    public static void main(String[] args) throws Exception {
        Path sqLiteChinookDatabasePath;
        if (args == null || args.length == 0) {
            sqLiteChinookDatabasePath = SQLiteGenerator.createSQLiteChinookDatabase();
        } else {
            Path path = Paths.get(args[0], new String[0]);
            sqLiteChinookDatabasePath = SQLiteGenerator.createSQLiteChinookDatabase(path);
        }
        Version.main(args);
        System.out.println(sqLiteChinookDatabasePath);
    }
}

