/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.chinook_database;

import java.util.Objects;

public enum DatabaseType {
    oracle("chinook-database/Chinook_Oracle.sql"),
    db2("chinook-database/Chinook_Db2.sql"),
    sqlserver("chinook-database/Chinook_SqlServer.sql", "GO"),
    sqlite("chinook-database/Chinook_Sqlite.sql"),
    mysql("chinook-database/Chinook_MySql.sql"),
    postgresql("chinook-database/Chinook_PostgreSql.sql");

    private final String classPathResourcePath;
    private final String scriptSeparator;

    public static DatabaseType fromConnectionUrl(String connectionUrl) {
        Objects.requireNonNull(connectionUrl);
        for (DatabaseType databaseType : DatabaseType.values()) {
            if (!connectionUrl.startsWith("jdbc:" + databaseType.name())) continue;
            return databaseType;
        }
        throw new IllegalArgumentException("Unknown JDBC connection URL, " + connectionUrl);
    }

    private DatabaseType(String classPathResourcePath) {
        this(classPathResourcePath, ";");
    }

    private DatabaseType(String classPathResourcePath, String scriptSeparator) {
        this.classPathResourcePath = classPathResourcePath;
        this.scriptSeparator = scriptSeparator;
    }

    public String getClassPathResourcePath() {
        return this.classPathResourcePath;
    }

    public String getScriptSeparator() {
        return this.scriptSeparator;
    }
}

