/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.chinook_database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import us.fatehi.chinook_database.ChinookDatabaseUtils;
import us.fatehi.chinook_database.DatabaseType;

@CommandLine.Command(description={"Creates the Chinook database schema on a server"}, name="Chinook Database Creator", mixinStandardHelpOptions=true)
public class ChinookDatabaseCreator
implements Callable<Integer> {
    @CommandLine.Option(names={"--url"}, required=true, description={"JDBC connection URL to the database"}, paramLabel="<url>")
    private String connectionUrl;
    @CommandLine.Option(names={"--user"}, description={"Database user name"}, paramLabel="<user>")
    private String user;
    @CommandLine.Option(names={"--password"}, description={"Database password"}, paramLabel="<password>")
    private String passwordProvided;

    public static int call(String ... args) {
        int exitCode = new CommandLine((Object)new ChinookDatabaseCreator()).execute(args);
        return exitCode;
    }

    public static void main(String ... args) {
        System.exit(ChinookDatabaseCreator.call(args));
    }

    private ChinookDatabaseCreator() {
    }

    @Override
    public Integer call() {
        try (Connection connection = DriverManager.getConnection(this.connectionUrl, this.user, this.passwordProvided);){
            DatabaseType server = DatabaseType.fromConnectionUrl(this.connectionUrl);
            ChinookDatabaseUtils.createChinookDatabase(server, connection);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }
}

