/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.chinook_database.resources;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import us.fatehi.chinook_database.DatabaseType;

public class OracleResource
implements Supplier<EncodedResource> {
    @Override
    public EncodedResource get() {
        try {
            ClassPathResource oracleResource = new ClassPathResource(DatabaseType.oracle.getClassPathResourcePath());
            BufferedReader reader = new BufferedReader(new InputStreamReader(oracleResource.getInputStream(), StandardCharsets.UTF_8));
            String sqlScript = reader.lines().filter(line -> !line.matches("conn chinook.*")).collect(Collectors.joining("\n"));
            Path sqlFile = Files.write(Files.createTempFile("chinook", ".sql", new FileAttribute[0]), sqlScript.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return new EncodedResource((Resource)new PathResource(sqlFile), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Cannot load Oracle resource", e);
        }
    }
}

