/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.chinook_database;

import java.sql.Connection;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import us.fatehi.chinook_database.DatabaseType;
import us.fatehi.chinook_database.resources.DB2Resource;
import us.fatehi.chinook_database.resources.MySQLResource;
import us.fatehi.chinook_database.resources.OracleResource;
import us.fatehi.chinook_database.resources.PostgreSQLResource;
import us.fatehi.chinook_database.resources.SQLServerResource;
import us.fatehi.chinook_database.resources.SQLiteResource;

public class ChinookDatabaseUtils {
    public static void createChinookDatabase(DatabaseType databaseType, Connection connection) {
        Objects.requireNonNull(databaseType, "No database type provided");
        Objects.requireNonNull(connection, "No connection provided");
        EncodedResource chinookDatabaseSql = ChinookDatabaseUtils.getResource(databaseType).get();
        ScriptUtils.executeSqlScript((Connection)connection, (EncodedResource)chinookDatabaseSql, (boolean)true, (boolean)true, (String)"--", (String)databaseType.getScriptSeparator(), (String)"/*", (String)"*/");
    }

    public static Supplier<EncodedResource> getResource(DatabaseType databaseType) {
        Objects.requireNonNull(databaseType, "No database type provided");
        switch (databaseType) {
            case db2: {
                return new DB2Resource();
            }
            case mysql: {
                return new MySQLResource();
            }
            case oracle: {
                return new OracleResource();
            }
            case postgresql: {
                return new PostgreSQLResource();
            }
            case sqlite: {
                return new SQLiteResource();
            }
            case sqlserver: {
                return new SQLServerResource();
            }
        }
        throw new IllegalArgumentException();
    }

    private ChinookDatabaseUtils() {
    }
}

