/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.xsoup.xevaluator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import us.codecraft.xsoup.Xsoup;

public abstract class ElementOperator {
    public abstract String operate(Element var1);

    public static class Regex
    extends ElementOperator {
        private Pattern pattern;
        private String attribute;
        private int group;

        public Regex(String expr) {
            this.pattern = Pattern.compile(expr);
        }

        public Regex(String expr, String attribute) {
            this.attribute = attribute;
            this.pattern = Pattern.compile(expr);
        }

        public Regex(String expr, String attribute, int group) {
            this.attribute = attribute;
            this.pattern = Pattern.compile(expr);
            this.group = group;
        }

        @Override
        public String operate(Element element) {
            Matcher matcher = this.pattern.matcher(this.getSource(element));
            if (matcher.find()) {
                return matcher.group(this.group);
            }
            return null;
        }

        protected String getSource(Element element) {
            if (this.attribute == null) {
                return element.outerHtml();
            }
            String attr = element.attr(this.attribute);
            Validate.notNull((Object)attr, (String)("Attribute " + this.attribute + " of " + element + " is not exist!"));
            return attr;
        }

        public String toString() {
            return String.format("regex(%s%s%s)", this.attribute != null ? "@" + this.attribute + "," : "", this.pattern.toString(), this.group != 0 ? "," + this.group : "");
        }
    }

    public static class GroupedText
    extends ElementOperator {
        private int group;

        public GroupedText(int group) {
            this.group = group;
        }

        @Override
        public String operate(Element element) {
            int index = 0;
            StringBuilder accum = new StringBuilder();
            for (Node node : element.childNodes()) {
                if (!(node instanceof TextNode)) continue;
                TextNode textNode = (TextNode)node;
                if (this.group == 0) {
                    accum.append(textNode.text());
                    continue;
                }
                if (++index != this.group) continue;
                return textNode.text();
            }
            return accum.toString();
        }

        public String toString() {
            return String.format("text(%d)", this.group);
        }
    }

    public static class TidyText
    extends ElementOperator {
        @Override
        public String operate(Element element) {
            return Xsoup.HtmlToPlainText(element);
        }

        public String toString() {
            return "tidyText()";
        }
    }

    public static class OuterHtml
    extends ElementOperator {
        @Override
        public String operate(Element element) {
            return element.outerHtml();
        }

        public String toString() {
            return "outerHtml()";
        }
    }

    public static class Html
    extends ElementOperator {
        @Override
        public String operate(Element element) {
            return element.html();
        }

        public String toString() {
            return "html()";
        }
    }

    public static class AllText
    extends ElementOperator {
        @Override
        public String operate(Element element) {
            return element.text();
        }

        public String toString() {
            return "allText()";
        }
    }

    public static class AttributeGetter
    extends ElementOperator {
        private String attribute;

        public AttributeGetter(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public String operate(Element element) {
            return element.attr(this.attribute);
        }

        public String toString() {
            return "@" + this.attribute;
        }
    }
}

