/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.xsoup;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;
import org.jsoup.select.Evaluator;
import org.jsoup.select.Selector;
import us.codecraft.xsoup.CombiningEvaluator;
import us.codecraft.xsoup.ElementOperator;
import us.codecraft.xsoup.StructuralEvaluator;
import us.codecraft.xsoup.XEvaluators;
import us.codecraft.xsoup.XPathEvaluator;
import us.codecraft.xsoup.XTokenQueue;

public class XPathParser {
    private String[] combinators = new String[]{"//", "/", "|"};
    private XTokenQueue tq;
    private String query;
    private List<Evaluator> evals = new ArrayList<Evaluator>();
    private ElementOperator elementOperator;
    private boolean noEvalAllow = false;
    private Pattern patternForText = Pattern.compile("text\\((\\d*)\\)");

    public XPathParser(String xpathStr) {
        this.query = xpathStr;
        this.tq = new XTokenQueue(xpathStr);
    }

    public XPathEvaluator parse() {
        while (!this.tq.isEmpty()) {
            Validate.isFalse((boolean)this.noEvalAllow, (String)("XPath error! No operator allowed after attribute or function!" + this.tq));
            if (this.tq.matchesAny(this.combinators)) {
                this.combinator(this.tq.consumeAny(this.combinators));
                continue;
            }
            this.findElements();
        }
        if (this.noEvalAllow) {
            return new XPathEvaluator(null, this.elementOperator);
        }
        if (this.evals.size() == 1) {
            return new XPathEvaluator(this.evals.get(0), this.elementOperator);
        }
        return new XPathEvaluator(new CombiningEvaluator.And(this.evals), this.elementOperator);
    }

    private void combinator(String combinator) {
        Object currentEval = this.evals.size() == 0 ? new StructuralEvaluator.Root() : (this.evals.size() == 1 ? this.evals.get(0) : new CombiningEvaluator.And(this.evals));
        this.evals.clear();
        String subQuery = this.consumeSubQuery();
        XPathEvaluator newEval = XPathParser.parse(subQuery);
        if (newEval.getAttribute() != null) {
            this.elementOperator = newEval.getElementOperator();
        }
        if (newEval.getEvaluator() != null) {
            if (combinator.equals("//")) {
                currentEval = new CombiningEvaluator.And(newEval.getEvaluator(), new StructuralEvaluator.Parent((Evaluator)currentEval));
            } else if (combinator.equals("/")) {
                currentEval = new CombiningEvaluator.And(newEval.getEvaluator(), new StructuralEvaluator.ImmediateParent((Evaluator)currentEval));
            } else if (combinator.equals("|")) {
                currentEval = new CombiningEvaluator.Or(newEval.getEvaluator(), new StructuralEvaluator.ImmediateParent((Evaluator)currentEval));
            }
        }
        this.evals.add((Evaluator)currentEval);
    }

    private String consumeSubQuery() {
        StringBuilder sq = new StringBuilder();
        while (!this.tq.isEmpty()) {
            if (this.tq.matches("(")) {
                sq.append("(").append(this.tq.chompBalanced('(', ')')).append(")");
                continue;
            }
            if (this.tq.matches("[")) {
                sq.append("[").append(this.tq.chompBalanced('[', ']')).append("]");
                continue;
            }
            if (this.tq.matchesAny(this.combinators)) break;
            sq.append(this.tq.consume());
        }
        return sq.toString();
    }

    private void findElements() {
        if (this.tq.matches("@")) {
            this.consumeAttribute();
        } else if (this.tq.matches("*")) {
            this.allElements();
        } else if (this.tq.matchesRegex("\\w+\\(.*\\)")) {
            this.consumeFunction();
        } else if (this.tq.matchesWord()) {
            this.byTag();
        } else if (this.tq.matches("[@")) {
            this.byAttribute();
        } else if (this.tq.matchesRegex("\\[\\d+\\]")) {
            this.byNth();
        } else {
            throw new Selector.SelectorParseException("Could not parse query '%s': unexpected token at '%s'", new Object[]{this.query, this.tq.remainder()});
        }
    }

    private void allElements() {
        this.tq.consume();
        this.evals.add((Evaluator)new Evaluator.AllElements());
    }

    private void byNth() {
        String nth = this.tq.chompBalanced('[', ']');
        this.evals.add((Evaluator)new Evaluator.IsNthOfType(0, Integer.parseInt(nth)));
    }

    private void consumeAttribute() {
        this.elementOperator = new ElementOperator.AttributeGetter(this.tq.remainder());
        this.noEvalAllow = true;
    }

    private void consumeFunction() {
        String remainder = this.tq.remainder();
        this.functionText(remainder);
        if (this.elementOperator == null) {
            this.functionRegex(remainder);
        }
        if (this.elementOperator == null) {
            this.elementOperator = new ElementOperator.Function(remainder);
        }
        this.noEvalAllow = true;
    }

    private void functionRegex(String remainder) {
        if (remainder.startsWith("regex(")) {
            Validate.isTrue((boolean)remainder.endsWith(")"), (String)("Unclosed bracket for function! " + remainder));
            List<String> params = XTokenQueue.trimQuotes(XTokenQueue.parseFuncionParams(remainder.substring("regex(".length(), remainder.length() - 1)));
            if (params.size() == 1) {
                this.elementOperator = new ElementOperator.Regex(params.get(0));
            } else if (params.size() == 2) {
                this.elementOperator = params.get(0).startsWith("@") ? new ElementOperator.Regex(params.get(1), params.get(0).substring(1)) : new ElementOperator.Regex(params.get(0), null, Integer.parseInt(params.get(1)));
            } else if (params.size() == 3) {
                this.elementOperator = new ElementOperator.Regex(params.get(1), params.get(0).substring(1), Integer.parseInt(params.get(2)));
            } else {
                throw new Selector.SelectorParseException("Unknown usage for regex()" + remainder, new Object[0]);
            }
        }
    }

    private void functionText(String remainder) {
        Matcher matcher = this.patternForText.matcher(remainder);
        if (matcher.matches()) {
            String group = matcher.group(1);
            int attributeGroup = group.equals("") ? 0 : Integer.parseInt(group);
            this.elementOperator = new ElementOperator.Text(remainder, attributeGroup);
        }
    }

    private void byTag() {
        String tagName = this.tq.consumeElementSelector();
        Validate.notEmpty((String)tagName);
        if (tagName.contains("|")) {
            tagName = tagName.replace("|", ":");
        }
        this.evals.add((Evaluator)new Evaluator.Tag(tagName.trim().toLowerCase()));
    }

    private void byAttribute() {
        XTokenQueue cq = new XTokenQueue(this.tq.chompBalanced('[', ']'));
        cq.matchChomp("@");
        String key = cq.consumeToAny("=", "!=", "^=", "$=", "*=", "~=");
        Validate.notEmpty((String)key);
        cq.consumeWhitespace();
        if (cq.isEmpty()) {
            if ("*".equals(key)) {
                this.evals.add(new XEvaluators.HasAnyAttribute());
            } else {
                this.evals.add((Evaluator)new Evaluator.Attribute(key));
            }
        } else if (cq.matchChomp("=")) {
            if (key.equals("class")) {
                String className = XTokenQueue.trimQuotes(cq.remainder());
                if (!className.contains(" ")) {
                    this.evals.add((Evaluator)new Evaluator.Class(className));
                } else {
                    this.evals.add((Evaluator)new Evaluator.AttributeWithValue(key, className));
                }
            } else {
                this.evals.add((Evaluator)new Evaluator.AttributeWithValue(key, XTokenQueue.trimQuotes(cq.remainder())));
            }
        } else if (cq.matchChomp("!=")) {
            this.evals.add((Evaluator)new Evaluator.AttributeWithValueNot(key, XTokenQueue.trimQuotes(cq.remainder())));
        } else if (cq.matchChomp("^=")) {
            this.evals.add((Evaluator)new Evaluator.AttributeWithValueStarting(key, XTokenQueue.trimQuotes(cq.remainder())));
        } else if (cq.matchChomp("$=")) {
            this.evals.add((Evaluator)new Evaluator.AttributeWithValueEnding(key, XTokenQueue.trimQuotes(cq.remainder())));
        } else if (cq.matchChomp("*=")) {
            this.evals.add((Evaluator)new Evaluator.AttributeWithValueContaining(key, XTokenQueue.trimQuotes(cq.remainder())));
        } else if (cq.matchChomp("~=")) {
            this.evals.add((Evaluator)new Evaluator.AttributeWithValueMatching(key, Pattern.compile(XTokenQueue.trimQuotes(cq.remainder()))));
        } else {
            throw new Selector.SelectorParseException("Could not parse attribute query '%s': unexpected token at '%s'", new Object[]{this.query, cq.remainder()});
        }
    }

    public static XPathEvaluator parse(String xpathStr) {
        XPathParser xPathParser = new XPathParser(xpathStr);
        return xPathParser.parse();
    }
}

