/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.xsoup;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import us.codecraft.xsoup.ElementOperator;
import us.codecraft.xsoup.XElements;

public class XPathEvaluator {
    private Evaluator evaluator;
    private ElementOperator elementOperator;

    public XPathEvaluator(Evaluator evaluator, ElementOperator elementOperator) {
        this.evaluator = evaluator;
        this.elementOperator = elementOperator;
    }

    public XElements evaluate(Element element) {
        Elements elements = Collector.collect((Evaluator)this.evaluator, (Element)element);
        return new XElements(elements, this.elementOperator);
    }

    public XElements evaluate(String html) {
        Elements elements = Collector.collect((Evaluator)this.evaluator, (Element)Jsoup.parse((String)html));
        return new XElements(elements, this.elementOperator);
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public String getAttribute() {
        if (this.elementOperator == null) {
            return null;
        }
        return this.elementOperator.toString();
    }

    public ElementOperator getElementOperator() {
        return this.elementOperator;
    }
}

