/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.xsoup;

import java.util.ArrayList;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import us.codecraft.xsoup.ElementOperator;
import us.codecraft.xsoup.XElement;

public class XElements
extends ArrayList<XElement> {
    private Elements elements;
    private ElementOperator elementOperator;

    public XElements(Elements elements, ElementOperator elementOperator) {
        this.elements = elements;
        this.elementOperator = elementOperator;
        this.initList();
    }

    private void initList() {
        for (Element element : this.elements) {
            this.add(new XElement(element, this.elementOperator));
        }
    }

    public String get() {
        if (this.size() < 1) {
            return null;
        }
        return ((XElement)this.get(0)).get();
    }

    public List<String> list() {
        ArrayList<String> resultStrings = new ArrayList<String>();
        for (XElement xElement : this) {
            String text = xElement.get();
            if (text == null) continue;
            resultStrings.add(text);
        }
        return resultStrings;
    }

    @Override
    public String toString() {
        return this.get();
    }
}

