/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.xsoup;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.examples.HtmlToPlainText;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public abstract class ElementOperator {
    protected String expr;

    public ElementOperator(String expr) {
        this.expr = expr;
    }

    public abstract String operate(Element var1);

    public String toString() {
        return this.expr;
    }

    public static class Regex
    extends Function {
        private Pattern pattern;
        private String attribute;
        private int group;

        public Regex(String expr) {
            super(expr);
            this.pattern = Pattern.compile(expr);
        }

        public Regex(String expr, String attribute) {
            super("@" + attribute + ":" + expr);
            this.attribute = attribute;
            this.pattern = Pattern.compile(expr);
        }

        public Regex(String expr, String attribute, int group) {
            super("@" + attribute + ":" + expr + "[" + group + "]");
            this.attribute = attribute;
            this.pattern = Pattern.compile(expr);
            this.group = group;
        }

        @Override
        public String operate(Element element) {
            Matcher matcher = this.pattern.matcher(this.getSource(element));
            if (matcher.find()) {
                return matcher.group(this.group);
            }
            return null;
        }

        protected String getSource(Element element) {
            if (this.attribute == null) {
                return element.outerHtml();
            }
            String attr = element.attr(this.attribute);
            Validate.notNull((Object)attr, (String)("Attribute " + this.attribute + " of " + element + " is not exist!"));
            return attr;
        }
    }

    public static class Text
    extends Function {
        private int group;

        public Text(String expr, int group) {
            super(expr);
            this.group = group;
        }

        @Override
        public String operate(Element element) {
            int index = 0;
            StringBuilder accum = new StringBuilder();
            for (Node node : element.childNodes()) {
                if (!(node instanceof TextNode)) continue;
                TextNode textNode = (TextNode)node;
                if (this.group == 0) {
                    accum.append(textNode.text());
                    continue;
                }
                if (++index != this.group) continue;
                return textNode.text();
            }
            return accum.toString();
        }
    }

    public static class Function
    extends ElementOperator {
        public Function(String expr) {
            super(expr);
        }

        @Override
        public String operate(Element element) {
            if (this.expr.equals("allText()")) {
                return element.text();
            }
            if (this.expr.equals("tidyText()")) {
                return new HtmlToPlainText().getPlainText(element);
            }
            if (this.expr.equals("html()")) {
                return element.html();
            }
            if (this.expr.equals("outerHtml()")) {
                return element.outerHtml();
            }
            throw new IllegalArgumentException("Unsupported function " + this.expr);
        }
    }

    public static class AttributeGetter
    extends ElementOperator {
        private String attribute;

        public AttributeGetter(String expr) {
            super(expr);
            if (expr.startsWith("@")) {
                this.attribute = expr.substring(1);
            }
        }

        @Override
        public String operate(Element element) {
            return element.attr(this.attribute);
        }
    }
}

