/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.example;

import java.util.List;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.model.ConsolePageModelPipeline;
import us.codecraft.webmagic.model.HasKey;
import us.codecraft.webmagic.model.OOSpider;
import us.codecraft.webmagic.model.annotation.ExtractBy;
import us.codecraft.webmagic.model.annotation.ExtractByUrl;
import us.codecraft.webmagic.model.annotation.HelpUrl;
import us.codecraft.webmagic.model.annotation.TargetUrl;

@TargetUrl(value={"https://github.com/\\w+/\\w+"})
@HelpUrl(value={"https://github.com/\\w+\\?tab=repositories", "https://github.com/\\w+", "https://github.com/explore/*"})
public class GithubRepo
implements HasKey {
    @ExtractBy(value="//h1[@class='public']/strong/a/text()", notNull=true)
    private String name;
    @ExtractByUrl(value="https://github\\.com/(\\w+)/.*")
    private String author;
    @ExtractBy(value="//div[@id='readme']/tidyText()")
    private String readme;
    @ExtractBy(value="//div[@class='repository-lang-stats']//li//span[@class='lang']/text()", multi=true)
    private List<String> language;
    @ExtractBy(value="//ul[@class='pagehead-actions']/li[1]//a[@class='social-count js-social-count']/text()")
    private int star;
    @ExtractBy(value="//ul[@class='pagehead-actions']/li[2]//a[@class='social-count']/text()")
    private int fork;
    @ExtractByUrl
    private String url;

    public static void main(String[] args) {
        OOSpider.create(Site.me().setSleepTime(100), new ConsolePageModelPipeline(), GithubRepo.class).addUrl(new String[]{"https://github.com/code4craft"}).thread(10).run();
    }

    @Override
    public String key() {
        return this.author + ":" + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getReadme() {
        return this.readme;
    }

    public String getAuthor() {
        return this.author;
    }

    public List<String> getLanguage() {
        return this.language;
    }

    public String getUrl() {
        return this.url;
    }

    public int getStar() {
        return this.star;
    }

    public int getFork() {
        return this.fork;
    }

    public String toString() {
        return "GithubRepo{name='" + this.name + "', author='" + this.author + "', readme='" + this.readme + "', language=" + this.language + ", star=" + this.star + ", fork=" + this.fork + ", url='" + this.url + "'}";
    }
}

