/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.downloader;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.AbstractDownloader;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.Selectable;

public class PhantomJSDownloader
extends AbstractDownloader {
    private static final Logger logger = LoggerFactory.getLogger(PhantomJSDownloader.class);
    private static String crawlJsPath;
    private static String phantomJsCommand;

    public PhantomJSDownloader() {
        this.initPhantomjsCrawlPath();
    }

    public PhantomJSDownloader(String phantomJsCommand) {
        this.initPhantomjsCrawlPath();
        PhantomJSDownloader.phantomJsCommand = phantomJsCommand;
    }

    public PhantomJSDownloader(String phantomJsCommand, String crawlJsPath) {
        PhantomJSDownloader.phantomJsCommand = phantomJsCommand;
        PhantomJSDownloader.crawlJsPath = crawlJsPath;
    }

    private void initPhantomjsCrawlPath() {
        crawlJsPath = new File(((Object)((Object)this)).getClass().getResource("/").getPath()).getPath() + System.getProperty("file.separator") + "crawl.js ";
    }

    public Page download(Request request, Task task) {
        if (logger.isInfoEnabled()) {
            logger.info("downloading page: " + request.getUrl());
        }
        Page page = Page.fail();
        try {
            String content = this.getPage(request);
            if (!content.contains("HTTP request failed")) {
                page.setDownloadSuccess(true);
                page.setRawText(content);
                page.setUrl((Selectable)new PlainText(request.getUrl()));
                page.setRequest(request);
                page.setStatusCode(200);
            }
            this.onSuccess(request, task);
        }
        catch (Exception e) {
            this.onError(request, task, e);
            logger.warn("download page {} error", (Object)request.getUrl(), (Object)e);
        }
        return page;
    }

    public void setThread(int threadNum) {
    }

    protected String getPage(Request request) throws Exception {
        String line;
        String url = request.getUrl();
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(phantomJsCommand + " " + crawlJsPath + " " + url);
        InputStream is = process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder builder = new StringBuilder();
        while ((line = br.readLine()) != null) {
            builder.append(line).append("\n");
        }
        return builder.toString();
    }

    static {
        phantomJsCommand = "phantomjs";
    }
}

