/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.pipeline;

import com.alibaba.fastjson.JSON;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.model.HasKey;
import us.codecraft.webmagic.pipeline.PageModelPipeline;
import us.codecraft.webmagic.utils.FilePersistentBase;

public class JsonFilePageModelPipeline
extends FilePersistentBase
implements PageModelPipeline {
    private Logger logger = Logger.getLogger(this.getClass());

    public JsonFilePageModelPipeline() {
        this.setPath("/data/webmagic/");
    }

    public JsonFilePageModelPipeline(String path) {
        this.setPath(path);
    }

    public void process(Object o, Task task) {
        String path = this.path + "/" + task.getUUID() + "/";
        try {
            String filename = o instanceof HasKey ? path + ((HasKey)o).key() + ".json" : path + DigestUtils.md5Hex((String)ToStringBuilder.reflectionToString((Object)o)) + ".json";
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.getFile(filename)));
            printWriter.write(JSON.toJSONString((Object)o));
            printWriter.close();
        }
        catch (IOException e) {
            this.logger.warn((Object)"write file error", (Throwable)e);
        }
    }
}

