/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.utils;

import java.util.ArrayList;
import java.util.List;
import us.codecraft.webmagic.model.annotation.ExtractBy;
import us.codecraft.webmagic.selector.CssSelector;
import us.codecraft.webmagic.selector.RegexSelector;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.XpathSelector;
import us.codecraft.webmagic.selector.XsoupSelector;
import us.codecraft.webmagic.utils.EnvironmentUtil;

public class ExtractorUtils {
    public static Selector getSelector(ExtractBy extractBy) {
        Selector selector;
        String value = extractBy.value();
        switch (extractBy.type()) {
            case Css: {
                selector = new CssSelector(value);
                break;
            }
            case Regex: {
                selector = new RegexSelector(value);
                break;
            }
            case XPath: {
                selector = ExtractorUtils.getXpathSelector(value);
                break;
            }
            default: {
                selector = ExtractorUtils.getXpathSelector(value);
            }
        }
        return selector;
    }

    private static Selector getXpathSelector(String value) {
        Object selector = EnvironmentUtil.useXsoup() ? new XsoupSelector(value) : new XpathSelector(value);
        return selector;
    }

    public static List<Selector> getSelectors(ExtractBy[] extractBies) {
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        if (extractBies == null) {
            return selectors;
        }
        for (ExtractBy extractBy : extractBies) {
            selectors.add(ExtractorUtils.getSelector(extractBy));
        }
        return selectors;
    }
}

