/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import com.alibaba.fastjson.JSON;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.Scheduler;

public class RedisScheduler
implements Scheduler {
    private JedisPool pool;
    private static final String QUEUE_PREFIX = "queue_";
    private static final String SET_PREFIX = "set_";
    private static final String ITEM_PREFIX = "item_";

    public RedisScheduler(String host) {
        this.pool = new JedisPool((GenericObjectPool.Config)new JedisPoolConfig(), host);
    }

    public RedisScheduler(JedisPool pool) {
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void push(Request request, Task task) {
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            if (!jedis.sismember(SET_PREFIX + task.getUUID(), request.getUrl()).booleanValue()) {
                jedis.rpush(QUEUE_PREFIX + task.getUUID(), request.getUrl());
                jedis.sadd(SET_PREFIX + task.getUUID(), request.getUrl());
                if (request.getExtras() != null) {
                    String field = DigestUtils.shaHex((String)request.getUrl());
                    String value = JSON.toJSONString((Object)request);
                    jedis.hset(ITEM_PREFIX + task.getUUID(), field, value);
                }
            }
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Request poll(Task task) {
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            Request request;
            String url = jedis.lpop(QUEUE_PREFIX + task.getUUID());
            if (url == null) {
                Request request2 = null;
                return request2;
            }
            String key = ITEM_PREFIX + task.getUUID();
            String field = DigestUtils.shaHex((String)url);
            byte[] bytes = jedis.hget(key.getBytes(), field.getBytes());
            if (bytes != null) {
                Request o;
                Request request3 = o = (Request)JSON.parseObject((String)new String(bytes), Request.class);
                return request3;
            }
            Request request4 = request = new Request(url);
            return request4;
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }
}

