/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.example;

import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.example.GithubRepo;
import us.codecraft.webmagic.model.PageMapper;
import us.codecraft.webmagic.processor.PageProcessor;

public class GithubRepoPageMapper
implements PageProcessor {
    private Site site = Site.me().setRetryTimes(3).setSleepTime(0);
    private PageMapper<GithubRepo> githubRepoPageMapper = new PageMapper<GithubRepo>(GithubRepo.class);

    public void process(Page page) {
        page.addTargetRequests((Iterable)page.getHtml().links().regex("(https://github\\.com/\\w+/\\w+)").all());
        page.addTargetRequests((Iterable)page.getHtml().links().regex("(https://github\\.com/\\w+)").all());
        GithubRepo githubRepo = this.githubRepoPageMapper.get(page);
        if (githubRepo == null) {
            page.setSkip(true);
        } else {
            page.putField("repo", (Object)githubRepo);
        }
    }

    public Site getSite() {
        return this.site;
    }

    public static void main(String[] args) {
        Spider.create((PageProcessor)new GithubRepoPageMapper()).addUrl(new String[]{"https://github.com/code4craft"}).thread(5).run();
    }
}

