/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.component.DuplicateRemover;

public class BloomFilterDuplicateRemover
implements DuplicateRemover {
    private int expectedInsertions;
    private double fpp;
    private AtomicInteger counter;
    private final BloomFilter<CharSequence> bloomFilter;

    public BloomFilterDuplicateRemover(int expectedInsertions) {
        this(expectedInsertions, 0.01);
    }

    public BloomFilterDuplicateRemover(int expectedInsertions, double fpp) {
        this.expectedInsertions = expectedInsertions;
        this.fpp = fpp;
        this.bloomFilter = this.rebuildBloomFilter();
    }

    protected BloomFilter<CharSequence> rebuildBloomFilter() {
        this.counter = new AtomicInteger(0);
        return BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charset.defaultCharset()), (int)this.expectedInsertions, (double)this.fpp);
    }

    public boolean isDuplicate(Request request, Task task) {
        boolean isDuplicate = this.bloomFilter.mightContain((Object)this.getUrl(request));
        if (!isDuplicate) {
            this.bloomFilter.put((Object)this.getUrl(request));
            this.counter.incrementAndGet();
        }
        return isDuplicate;
    }

    protected String getUrl(Request request) {
        return request.getUrl();
    }

    public void resetDuplicateCheck(Task task) {
        this.rebuildBloomFilter();
    }

    public int getTotalRequestsCount(Task task) {
        return this.counter.get();
    }
}

