/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.utils;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.utils.UrlUtils;

public abstract class CharsetUtils {
    private static Logger logger = LoggerFactory.getLogger(CharsetUtils.class);

    private CharsetUtils() {
        throw new AssertionError((Object)"No us.codecraft.webmagic.utils.CharsetUtils instances for you!");
    }

    public static String detectCharset(String contentType, byte[] contentBytes) throws IOException {
        String charset = UrlUtils.getCharset(contentType);
        if (StringUtils.isNotBlank((CharSequence)contentType) && StringUtils.isNotBlank((CharSequence)charset)) {
            logger.debug("Auto get charset: {}", (Object)charset);
            return charset;
        }
        Charset defaultCharset = Charset.defaultCharset();
        String content = new String(contentBytes, defaultCharset);
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            Document document = Jsoup.parse((String)content);
            Elements links = document.select("meta");
            for (Element link : links) {
                String metaContent = link.attr("content");
                String metaCharset = link.attr("charset");
                if (metaContent.indexOf("charset") != -1) {
                    metaContent = metaContent.substring(metaContent.indexOf("charset"), metaContent.length());
                    charset = metaContent.split("=")[1];
                    break;
                }
                if (!StringUtils.isNotEmpty((CharSequence)metaCharset)) continue;
                charset = metaCharset;
                break;
            }
        }
        logger.debug("Auto get charset: {}", (Object)charset);
        return charset;
    }
}

