/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.http.annotation.ThreadSafe;
import org.apache.log4j.Logger;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.Scheduler;

@ThreadSafe
public class QueueScheduler
implements Scheduler {
    private Logger logger = Logger.getLogger(this.getClass());
    private BlockingQueue<Request> queue = new LinkedBlockingQueue<Request>();
    private Set<String> urls = new HashSet<String>();

    @Override
    public synchronized void push(Request request, Task task) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("push to queue " + request.getUrl()));
        }
        if (this.urls.add(request.getUrl())) {
            this.queue.add(request);
        }
    }

    @Override
    public synchronized Request poll(Task task) {
        return (Request)this.queue.poll();
    }
}

