/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.downloader;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.downloader.HttpClientGenerator;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.utils.UrlUtils;

@ThreadSafe
public class HttpClientDownloader
implements Downloader {
    private Logger logger = Logger.getLogger(this.getClass());
    private final Map<String, CloseableHttpClient> httpClients = new HashMap<String, CloseableHttpClient>();
    private HttpClientGenerator httpClientGenerator = new HttpClientGenerator();

    public Html download(String url) {
        Page page = this.download(new Request(url), null);
        return page.getHtml();
    }

    public Html download(String url, String charset) {
        Page page = this.download(new Request(url), Site.me().setCharset(charset).toTask());
        return page.getHtml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getHttpClient(Site site) {
        if (site == null) {
            return this.httpClientGenerator.getClient(null);
        }
        String domain = site.getDomain();
        CloseableHttpClient httpClient = this.httpClients.get(domain);
        if (httpClient == null) {
            HttpClientDownloader httpClientDownloader = this;
            synchronized (httpClientDownloader) {
                if (httpClient == null) {
                    httpClient = this.httpClientGenerator.getClient(site);
                    this.httpClients.put(domain, httpClient);
                }
            }
        }
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page download(Request request, Task task) {
        HashSet acceptStatCode;
        Site site = null;
        if (task != null) {
            site = task.getSite();
        }
        String charset = null;
        Map<String, String> headers = null;
        if (site != null) {
            acceptStatCode = site.getAcceptStatCode();
            charset = site.getCharset();
            headers = site.getHeaders();
        } else {
            acceptStatCode = Sets.newHashSet((Object[])new Integer[]{200});
        }
        this.logger.info((Object)("downloading page " + request.getUrl()));
        RequestBuilder requestBuilder = RequestBuilder.get().setUri(request.getUrl());
        if (headers != null) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                requestBuilder.addHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(site.getTimeOut()).setConnectTimeout(site.getTimeOut()).setCookieSpec("best-match");
        if (site != null && site.getHttpProxy() != null) {
            requestConfigBuilder.setProxy(site.getHttpProxy());
        }
        requestBuilder.setConfig(requestConfigBuilder.build());
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.getHttpClient(site).execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (acceptStatCode.contains(statusCode)) {
                if (charset == null) {
                    String value = httpResponse.getEntity().getContentType().getValue();
                    charset = UrlUtils.getCharset(value);
                }
                Page page = this.handleResponse(request, charset, (HttpResponse)httpResponse, task);
                return page;
            }
            this.logger.warn((Object)("code error " + statusCode + "\t" + request.getUrl()));
            Page page = null;
            return page;
        }
        catch (IOException e) {
            this.logger.warn((Object)("download page " + request.getUrl() + " error"), (Throwable)e);
            if (site.getCycleRetryTimes() > 0) {
                Page page = this.addToCycleRetry(request, site);
                return page;
            }
            Page page = null;
            return page;
        }
        finally {
            try {
                if (httpResponse != null) {
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)"close response fail", (Throwable)e);
            }
        }
    }

    private Page addToCycleRetry(Request request, Site site) {
        Page page = new Page();
        Object cycleTriedTimesObject = request.getExtra("_cycle_tried_times");
        if (cycleTriedTimesObject == null) {
            page.addTargetRequest(request.setPriority(0L).putExtra("_cycle_tried_times", 1));
        } else {
            int cycleTriedTimes = (Integer)cycleTriedTimesObject;
            if (++cycleTriedTimes >= site.getCycleRetryTimes()) {
                return null;
            }
            page.addTargetRequest(request.setPriority(0L).putExtra("_cycle_tried_times", 1));
        }
        return page;
    }

    protected Page handleResponse(Request request, String charset, HttpResponse httpResponse, Task task) throws IOException {
        String content = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)charset);
        Page page = new Page();
        page.setHtml(new Html(UrlUtils.fixAllRelativeHrefs(content, request.getUrl())));
        page.setUrl(new PlainText(request.getUrl()));
        page.setRequest(request);
        return page;
    }

    @Override
    public void setThread(int thread) {
        this.httpClientGenerator.setPoolSize(thread);
    }
}

