/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.downloader.HttpClientDownloader;
import us.codecraft.webmagic.pipeline.ConsolePipeline;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.scheduler.QueueScheduler;
import us.codecraft.webmagic.scheduler.Scheduler;
import us.codecraft.webmagic.utils.ThreadUtils;

public class Spider
implements Runnable,
Task {
    protected Downloader downloader;
    protected List<Pipeline> pipelines = new ArrayList<Pipeline>();
    protected PageProcessor pageProcessor;
    protected List<String> startUrls;
    protected Site site;
    protected String uuid;
    protected Scheduler scheduler = new QueueScheduler();
    protected Logger logger = Logger.getLogger(this.getClass());
    protected ExecutorService executorService;
    protected int threadNum = 1;
    protected AtomicInteger stat = new AtomicInteger(0);
    protected static final int STAT_INIT = 0;
    protected static final int STAT_RUNNING = 1;
    protected static final int STAT_STOPPED = 2;

    public Spider(PageProcessor pageProcessor) {
        this.pageProcessor = pageProcessor;
        this.site = pageProcessor.getSite();
        this.startUrls = pageProcessor.getSite().getStartUrls();
    }

    public static Spider create(PageProcessor pageProcessor) {
        return new Spider(pageProcessor);
    }

    public Spider startUrls(List<String> startUrls) {
        this.checkIfNotRunning();
        this.startUrls = startUrls;
        return this;
    }

    public Spider setUUID(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public Spider scheduler(Scheduler scheduler) {
        return this.setScheduler(scheduler);
    }

    public Spider setScheduler(Scheduler scheduler) {
        this.checkIfNotRunning();
        this.scheduler = scheduler;
        return this;
    }

    public Spider pipeline(Pipeline pipeline) {
        return this.addPipeline(pipeline);
    }

    public Spider addPipeline(Pipeline pipeline) {
        this.checkIfNotRunning();
        this.pipelines.add(pipeline);
        return this;
    }

    public Spider clearPipeline() {
        this.pipelines = new ArrayList<Pipeline>();
        return this;
    }

    public Spider downloader(Downloader downloader) {
        return this.setDownloader(downloader);
    }

    public Spider setDownloader(Downloader downloader) {
        this.checkIfNotRunning();
        this.downloader = downloader;
        return this;
    }

    protected void checkComponent() {
        if (this.downloader == null) {
            this.downloader = new HttpClientDownloader();
        }
        if (this.pipelines.isEmpty()) {
            this.pipelines.add(new ConsolePipeline());
        }
        this.downloader.setThread(this.threadNum);
    }

    @Override
    public void run() {
        if (!this.stat.compareAndSet(0, 1)) {
            throw new IllegalStateException("Spider is already running!");
        }
        this.checkComponent();
        if (this.startUrls != null) {
            for (String startUrl : this.startUrls) {
                this.scheduler.push(new Request(startUrl), this);
            }
        }
        Request request = this.scheduler.poll(this);
        if (this.executorService == null) {
            while (request != null) {
                this.processRequest(request);
                request = this.scheduler.poll(this);
            }
        } else {
            final AtomicInteger threadAlive = new AtomicInteger(0);
            do {
                if (request == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                } else {
                    final Request requestFinal = request;
                    threadAlive.incrementAndGet();
                    this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            Spider.this.processRequest(requestFinal);
                            threadAlive.decrementAndGet();
                        }
                    });
                }
                request = this.scheduler.poll(this);
            } while (threadAlive.get() != 0 || (request = this.scheduler.poll(this)) != null);
            this.executorService.shutdown();
        }
        this.stat.compareAndSet(1, 2);
        this.destroy();
    }

    protected void destroy() {
        this.destroyEach(this.downloader);
        this.destroyEach(this.pageProcessor);
        for (Pipeline pipeline : this.pipelines) {
            this.destroyEach(pipeline);
        }
    }

    private void destroyEach(Object object) {
        if (object instanceof Closeable) {
            try {
                ((Closeable)object).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void test(String ... urls) {
        this.checkComponent();
        if (urls.length > 0) {
            for (String url : urls) {
                this.processRequest(new Request(url));
            }
        }
    }

    protected void processRequest(Request request) {
        Page page = this.downloader.download(request, this);
        if (page == null) {
            this.sleep(this.site.getSleepTime());
            return;
        }
        this.pageProcessor.process(page);
        this.addRequest(page);
        if (!page.getResultItems().isSkip()) {
            for (Pipeline pipeline : this.pipelines) {
                pipeline.process(page.getResultItems(), this);
            }
        }
        this.sleep(this.site.getSleepTime());
    }

    protected void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void addRequest(Page page) {
        if (CollectionUtils.isNotEmpty(page.getTargetRequests())) {
            for (Request request : page.getTargetRequests()) {
                this.scheduler.push(request, this);
            }
        }
    }

    protected void checkIfNotRunning() {
        if (!this.stat.compareAndSet(0, 0)) {
            throw new IllegalStateException("Spider is already running!");
        }
    }

    public void runAsync() {
        Thread thread = new Thread(this);
        thread.setDaemon(false);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spider thread(int threadNum) {
        this.checkIfNotRunning();
        this.threadNum = threadNum;
        if (threadNum <= 0) {
            throw new IllegalArgumentException("threadNum should be more than one!");
        }
        if (threadNum == 1) {
            return this;
        }
        Spider spider = this;
        synchronized (spider) {
            this.executorService = ThreadUtils.newFixedThreadPool(threadNum);
        }
        return this;
    }

    @Override
    public String getUUID() {
        if (this.uuid != null) {
            return this.uuid;
        }
        if (this.site != null) {
            return this.site.getDomain();
        }
        return null;
    }

    @Override
    public Site getSite() {
        return this.site;
    }
}

