/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JSR223TestElement;
import org.slf4j.Logger;
import us.abstracta.jmeter.javadsl.core.BaseTestElement;

public abstract class DslJsr223TestElement
extends BaseTestElement {
    private static int scriptId = 1;
    private final String script;
    private String language = "groovy";
    private final Map<String, Object> jmeterProps = new HashMap<String, Object>();

    public DslJsr223TestElement(String name, String defaultName, String script) {
        super(name != null ? name : defaultName, TestBeanGUI.class);
        this.script = script;
    }

    public DslJsr223TestElement(String name, String defaultName, Jsr223Script<?> script, Class<?> varsClass) {
        super(name != null ? name : defaultName, TestBeanGUI.class);
        String buildScriptId = DslJsr223TestElement.buildScriptId();
        this.jmeterProps.put(buildScriptId, script);
        this.script = DslJsr223TestElement.buildScriptString(buildScriptId, varsClass);
        System.out.println(this.script);
    }

    private static String buildScriptId() {
        return "Jsr223Script" + scriptId++;
    }

    private static String buildScriptString(String scriptId, Class<?> varsClass) {
        return "// It is currently not supported to run scripts defined in Java code in JMeter GUI or non Embedded Engine (eg: BlazeMeter).\ndef script = (" + Jsr223Script.class.getName() + ") props.get('" + scriptId + "')\nscript.run(new " + varsClass.getName() + "(" + DslJsr223TestElement.buildConstructorParameters(varsClass) + "))";
    }

    private static String buildConstructorParameters(Class<?> varsClass) {
        return Arrays.stream(varsClass.getFields()).map(Field::getName).collect(Collectors.joining(","));
    }

    public DslJsr223TestElement language(String language) {
        this.language = language;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        if (!this.jmeterProps.isEmpty()) {
            JMeterUtils.getJMeterProperties().putAll(this.jmeterProps);
        }
        JSR223TestElement ret = this.buildJsr223TestElement();
        ret.setProperty("script", this.script);
        ret.setProperty("scriptLanguage", this.language);
        return ret;
    }

    protected abstract JSR223TestElement buildJsr223TestElement();

    protected static class Jsr223ScriptVars {
        public JMeterContext ctx;
        public JMeterVariables vars;
        public Properties props;
        public Sampler sampler;
        public Logger log;
        public String Label;

        public Jsr223ScriptVars(JMeterContext ctx, JMeterVariables vars, Properties props, Sampler sampler, Logger log, String label) {
            this.ctx = ctx;
            this.vars = vars;
            this.props = props;
            this.sampler = sampler;
            this.log = log;
            this.Label = label;
        }
    }

    protected static interface Jsr223Script<T extends Jsr223ScriptVars> {
        public void run(T var1) throws Exception;
    }
}

