/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.util.Objects;

public class JmeterUrl {
    public static final String SCHEME_DELIMITER = "://";
    private final String protocol;
    private final String host;
    private final String port;
    private final String path;

    public JmeterUrl(String protocol, String host, String port, String path) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public static JmeterUrl valueOf(String url) {
        int pos = url.indexOf(SCHEME_DELIMITER);
        if (pos < 0) {
            return new JmeterUrl(null, null, null, url);
        }
        String protocol = url.substring(0, pos);
        String authority = url = url.substring(pos + SCHEME_DELIMITER.length());
        String path = "/";
        pos = url.indexOf("/");
        if (pos >= 0) {
            authority = url.substring(0, pos);
            path = url.substring(pos);
        }
        pos = authority.indexOf(":");
        String host = authority;
        String port = "";
        if (pos >= 0) {
            host = authority.substring(0, pos);
            port = authority.substring(pos + 1);
        }
        return new JmeterUrl(protocol, host, port, path);
    }

    public String protocol() {
        return this.protocol;
    }

    public String host() {
        return this.host;
    }

    public String port() {
        return this.port;
    }

    public String path() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmeterUrl that = (JmeterUrl)o;
        return Objects.equals(this.protocol, that.protocol) && Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.host, this.port, this.path);
    }

    public String toString() {
        if (this.isNullOrEmpty(this.host)) {
            return this.path;
        }
        return (this.isNullOrEmpty(this.protocol) ? "http" : this.protocol) + SCHEME_DELIMITER + this.host + (this.isNullOrEmpty(this.port) ? "" : ":" + this.port) + (this.isNullOrEmpty(this.path) ? "" : this.path);
    }

    boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

