/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.jmeter.samplers.SampleResult;
import us.abstracta.jmeter.javadsl.core.stats.StatsSummary;

public class TestPlanStats {
    protected final Supplier<StatsSummary> statsSummaryBuilder;
    protected StatsSummary overallStats;
    protected final Map<String, StatsSummary> labeledStats = new ConcurrentHashMap<String, StatsSummary>();
    private Instant start;
    private Instant end;

    public TestPlanStats(Supplier<StatsSummary> statsSummaryBuilder) {
        this.statsSummaryBuilder = statsSummaryBuilder;
        this.overallStats = statsSummaryBuilder.get();
    }

    public synchronized void addSampleResult(SampleResult result) {
        this.overallStats.add(result);
        StatsSummary labelStats = this.labeledStats.computeIfAbsent(result.getSampleLabel(), label -> this.statsSummaryBuilder.get());
        labelStats.add(result);
    }

    public void setStart(Instant start) {
        this.start = start;
    }

    public void setEnd(Instant end) {
        this.end = end;
    }

    public Duration duration() {
        return Duration.between(this.start, this.end);
    }

    public StatsSummary overall() {
        return this.overallStats;
    }

    public StatsSummary byLabel(String label) {
        return this.labeledStats.get(label);
    }

    public Set<String> labels() {
        return this.labeledStats.keySet();
    }
}

