/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.listeners;

import java.io.File;
import org.apache.jmeter.report.config.ConfigurationException;
import org.apache.jmeter.report.dashboard.GenerationException;
import org.apache.jmeter.report.dashboard.ReportGenerator;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.SimpleDataWriter;
import us.abstracta.jmeter.javadsl.core.BaseTestElement;
import us.abstracta.jmeter.javadsl.core.DslSampler;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.DslThreadGroup;

public class HtmlReporter
extends BaseTestElement
implements DslTestPlan.TestPlanChild,
DslThreadGroup.ThreadGroupChild,
DslSampler.SamplerChild {
    private final File reportDirectory;

    public HtmlReporter(String reportDirectory) {
        super("Simple Data Writer", SimpleDataWriter.class);
        this.reportDirectory = new File(reportDirectory);
    }

    @Override
    public TestElement buildTestElement() {
        if (!this.reportDirectory.exists()) {
            this.reportDirectory.mkdirs();
        }
        File resultsFile = new File(this.reportDirectory, "report.jtl");
        HtmlReportSummariser reporter = new HtmlReportSummariser(resultsFile);
        ResultCollector logger = new ResultCollector((Summariser)reporter);
        reporter.setCollector(logger);
        logger.setFilename(resultsFile.getPath());
        return logger;
    }

    private static class HtmlReportSummariser
    extends Summariser {
        private final File resultsFile;
        private ResultCollector logger;

        private HtmlReportSummariser(File resultsFile) {
            this.resultsFile = resultsFile;
        }

        public void setCollector(ResultCollector logger) {
            this.logger = logger;
        }

        public void testStarted() {
        }

        public void sampleOccurred(SampleEvent e) {
        }

        public void testEnded(String host) {
            JMeterUtils.setProperty((String)"jmeter.reportgenerator.outputdir", (String)new File(this.resultsFile.getParent()).getAbsolutePath());
            try {
                this.logger.flushFile();
                new ReportGenerator(this.resultsFile.getPath(), null).generate();
            }
            catch (ConfigurationException | GenerationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

