/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.config.gui.HttpDefaultsGui;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleGuiClassCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.configs.BaseConfigElement;
import us.abstracta.jmeter.javadsl.http.ClientImplParam;
import us.abstracta.jmeter.javadsl.http.DslBaseHttpSampler;
import us.abstracta.jmeter.javadsl.http.DslHttpSampler;
import us.abstracta.jmeter.javadsl.http.EncodingParam;
import us.abstracta.jmeter.javadsl.http.JmeterUrl;

public class DslHttpDefaults
extends BaseConfigElement {
    private String protocol;
    private String host;
    private String port;
    private String path;
    private Charset encoding;
    private String proxyUrl;
    private String proxyUser;
    private String proxyPassword;
    private boolean downloadEmbeddedResources;
    private DslHttpSampler.HttpClientImpl clientImpl;

    public DslHttpDefaults() {
        super("HTTP Request Defaults", HttpDefaultsGui.class);
    }

    public DslHttpDefaults url(String url) {
        JmeterUrl parsedUrl = JmeterUrl.valueOf(url);
        this.protocol = parsedUrl.protocol();
        this.host = parsedUrl.host();
        this.port = parsedUrl.port();
        this.path = parsedUrl.path();
        return this;
    }

    public DslHttpDefaults protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public DslHttpDefaults host(String host) {
        this.host = host;
        return this;
    }

    public DslHttpDefaults port(int port) {
        this.port = String.valueOf(port);
        return this;
    }

    public DslHttpDefaults path(String path) {
        this.path = path;
        return this;
    }

    public DslHttpDefaults encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public DslHttpDefaults downloadEmbeddedResources() {
        this.downloadEmbeddedResources = true;
        return this;
    }

    public DslHttpDefaults proxy(String url) {
        this.proxyUrl = url;
        return this;
    }

    public DslHttpDefaults proxy(String url, String username, String password) {
        this.proxyUrl = url;
        this.proxyUser = username;
        this.proxyPassword = password;
        return this;
    }

    public DslHttpDefaults clientImpl(DslHttpSampler.HttpClientImpl clientImpl) {
        this.clientImpl = clientImpl;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        ConfigTestElement ret = new ConfigTestElement();
        if (this.protocol != null) {
            ret.setProperty("HTTPSampler.protocol", this.protocol);
        }
        if (this.host != null) {
            ret.setProperty("HTTPSampler.domain", this.host);
        }
        if (this.port != null) {
            ret.setProperty("HTTPSampler.port", this.port);
        }
        if (this.path != null) {
            ret.setProperty("HTTPSampler.path", this.path);
        }
        if (this.encoding != null) {
            ret.setProperty("HTTPSampler.contentEncoding", this.encoding.toString());
        }
        if (this.proxyUrl != null) {
            JmeterUrl parsedUrl = JmeterUrl.valueOf(this.proxyUrl);
            ret.setProperty("HTTPSampler.proxyScheme", parsedUrl.protocol());
            ret.setProperty("HTTPSampler.proxyHost", parsedUrl.host());
            ret.setProperty("HTTPSampler.proxyPort", parsedUrl.port());
            if (this.proxyUser != null) {
                ret.setProperty("HTTPSampler.proxyUser", this.proxyUser);
            }
            if (this.proxyPassword != null) {
                ret.setProperty("HTTPSampler.proxyPass", this.proxyPassword);
            }
        }
        if (this.downloadEmbeddedResources) {
            ret.setProperty("HTTPSampler.image_parser", true);
            ret.setProperty("HTTPSampler.concurrentDwn", true);
        }
        if (this.clientImpl != null) {
            ret.setProperty("HTTPSampler.implementation", this.clientImpl.propertyValue);
        }
        return ret;
    }

    public static class CodeBuilder
    extends SingleGuiClassCallBuilder {
        public CodeBuilder(List<Method> builderMethods) {
            super(HttpDefaultsGui.class, builderMethods);
        }

        @Override
        protected MethodCall buildMethodCall(MethodCallContext context) {
            MethodCall ret = this.buildMethodCall(new MethodParam[0]);
            TestElementParamBuilder paramBuilder = new TestElementParamBuilder(context.getTestElement());
            MethodParam protocol = paramBuilder.stringParam("HTTPSampler.protocol");
            MethodParam host = paramBuilder.stringParam("HTTPSampler.domain");
            MethodParam port = paramBuilder.stringParam("HTTPSampler.port");
            MethodParam path = paramBuilder.stringParam("HTTPSampler.path", "/");
            if (!protocol.isDefault() && !host.isDefault()) {
                ret.chain("url", DslBaseHttpSampler.BaseHttpSamplerCodeBuilder.buildUrlParam(protocol, host, port, path));
            } else {
                ret.chain("protocol", protocol).chain("host", host).chain("port", port).chain("path", path);
            }
            ret.chain("encoding", EncodingParam.from(paramBuilder)).chain("downloadEmbeddedResources", paramBuilder.boolParam("HTTPSampler.image_parser", false)).chain("clientImpl", ClientImplParam.from(paramBuilder));
            return ret;
        }
    }
}

