/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.configs;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.protocol.java.sampler.JSR223Sampler;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.configs.BaseConfigElement;

public class DslVariables
extends BaseConfigElement {
    private final Map<String, String> vars = new LinkedHashMap<String, String>();

    public DslVariables() {
        super("User Defined Variables", ArgumentsPanel.class);
    }

    public DslVariables set(String varName, String varValue) {
        this.vars.put(varName, varValue);
        return this;
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        TestElement ret = context.getParent().isRoot() ? this.buildTestElement() : this.buildJs223Sampler();
        return parent.add((Object)DslVariables.configureTestElement(ret, this.name, this.guiClass));
    }

    @Override
    protected TestElement buildTestElement() {
        Arguments ret = new Arguments();
        for (Map.Entry<String, String> entry : this.vars.entrySet()) {
            ret.addArgument(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    private JSR223Sampler buildJs223Sampler() {
        this.name = "Set Variables";
        this.guiClass = TestBeanGUI.class;
        JSR223Sampler ret = new JSR223Sampler();
        ret.setScriptLanguage("groovy");
        ret.setScript(this.buildGroovyScript());
        return ret;
    }

    private String buildGroovyScript() {
        boolean containsFunction = false;
        StringBuilder ret = new StringBuilder();
        for (Map.Entry<String, String> entry : this.vars.entrySet()) {
            boolean keyContainsFunction = this.stringContainsFunction(entry.getKey());
            boolean valueContainsFunction = this.stringContainsFunction(entry.getValue());
            containsFunction = containsFunction || keyContainsFunction || valueContainsFunction;
            ret.append(String.format("vars.put(%s, %s)\n", this.formatStringParam(entry.getKey(), keyContainsFunction), this.formatStringParam(entry.getValue(), valueContainsFunction)));
        }
        ret.append("SampleResult.ignore = true\n");
        return (containsFunction ? "// need to use CompoundVariable with string replacement to avoid generating incorrect groovy when expression resulting string contains groovy special characters (like apostrophes, new lines, etc).\nimport org.apache.jmeter.engine.util.CompoundVariable\n\n" : "") + ret;
    }

    private boolean stringContainsFunction(String val) {
        return val.contains("${");
    }

    private String formatStringParam(String param, boolean containsFunction) {
        String escapedParam = this.escapeGroovyString(param);
        return containsFunction ? String.format("new CompoundVariable('%s'.replaceAll('([$#])#\\\\{', '$1{')).execute()", escapedParam.replaceAll("([$#])\\{", "$1#{")) : "'" + escapedParam + "'";
    }

    private String escapeGroovyString(String var) {
        return var.replace("\\", "\\\\").replace("'", "\\'").replace("\r", "\\r").replace("\n", "\\n").replace("\t", "\\t");
    }

    public static class CallContextEntry {
        private final Map<String, String> vars = new LinkedHashMap<String, String>();
    }

    public static class CodeBuilder
    extends SingleTestElementCallBuilder<Arguments> {
        public CodeBuilder(List<Method> builderMethods) {
            super(Arguments.class, builderMethods);
        }

        @Override
        protected MethodCall buildMethodCall(Arguments testElement, MethodCallContext context) {
            this.mergeVariablesIntoRootContextVariables(testElement, context);
            return MethodCall.emptyCall();
        }

        private void mergeVariablesIntoRootContextVariables(Arguments testElement, MethodCallContext context) {
            MethodCallContext rootContext = context.getRoot();
            CallContextEntry entry = (CallContextEntry)rootContext.getEntry(this.getClass());
            if (entry == null) {
                entry = new CallContextEntry();
                rootContext.setEntry(this.getClass(), entry);
                rootContext.addEndListener(this.buildContextEndListener());
            }
            entry.vars.putAll(testElement.getArgumentsAsMap());
        }

        private MethodCallContext.MethodCallContextEndListener buildContextEndListener() {
            return (ctx, call) -> {
                CallContextEntry ctxEntry = (CallContextEntry)ctx.getEntry(this.getClass());
                if (ctxEntry.vars.isEmpty()) {
                    return;
                }
                MethodCall ret = this.buildMethodCall(new MethodParam[0]);
                ctxEntry.vars.forEach((k, v) -> ret.chain("set", new MethodParam.StringParam((String)k), new MethodParam.StringParam((String)v)));
                call.child(ret);
            };
        }
    }
}

