/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.codegeneration;

import java.time.Duration;
import java.util.function.Function;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;

public class TestElementParamBuilder {
    private final TestElement testElement;
    private final String propsPrefix;

    public TestElementParamBuilder(TestElement testElement) {
        this(testElement, null);
    }

    public TestElementParamBuilder(TestElement testElement, String propsPrefix) {
        this.testElement = testElement;
        this.propsPrefix = propsPrefix != null ? propsPrefix + "." : "";
    }

    public MethodParam.StringParam nameParam(String defaultName) {
        return new MethodParam.NameParam(this.testElement.getName(), defaultName);
    }

    public MethodParam.IntParam intParam(String propName) {
        return new MethodParam.IntParam(this.parseProp(propName, Integer::valueOf), null);
    }

    private <T> T parseProp(String propName, Function<String, T> parser) {
        String propVal = this.prop(propName).getStringValue();
        if (propVal.isEmpty()) {
            return null;
        }
        try {
            return parser.apply(propVal);
        }
        catch (NumberFormatException e) {
            throw new UnsupportedOperationException(String.format("DSL does currently only support numeric values for %s, but found: %s. If you need this support please open an issue in GitHub repository.", this.propsPrefix + propName, propVal), e);
        }
    }

    public JMeterProperty prop(String propName) {
        propName = this.propsPrefix + propName;
        String[] propLevels = propName.split("/");
        TestElement propHolder = this.testElement;
        for (int i = 0; i < propLevels.length - 1; ++i) {
            propHolder = (TestElement)this.testElement.getProperty(propLevels[i]).getObjectValue();
        }
        return propHolder.getProperty(propLevels[propLevels.length - 1]);
    }

    public MethodParam.StringParam stringParam(String propName, String defaultValue) {
        return new MethodParam.StringParam(this.prop(propName).getStringValue(), defaultValue);
    }

    public MethodParam.StringParam stringParam(String propName) {
        return this.stringParam(propName, null);
    }

    public MethodParam.BoolParam boolParam(String propName, boolean defaultValue) {
        return new MethodParam.BoolParam(this.parseBool(propName), defaultValue);
    }

    private Boolean parseBool(String propName) {
        String s = this.prop(propName).getStringValue();
        if (s.isEmpty()) {
            return null;
        }
        if (!String.valueOf(true).equals(s) && !String.valueOf(false).equals(s)) {
            throw new UnsupportedOperationException(String.format("DSL does currently only support true or false values for %s, but found: %s. If you need this support please open an issue in GitHub repository.", propName, s));
        }
        return Boolean.valueOf(s);
    }

    public MethodParam.DurationParam durationParam(String propName, Duration defaultValue) {
        Long durationSecs = this.parseProp(propName, Long::parseLong);
        return new MethodParam.DurationParam(durationSecs != null ? Duration.ofSeconds(durationSecs) : null, defaultValue);
    }

    public MethodParam.DurationParam durationParam(String propName) {
        return this.durationParam(propName, null);
    }
}

