/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.engines;

import java.time.Duration;
import java.time.Instant;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.PSquarePercentile;
import org.apache.jmeter.samplers.SampleResult;
import us.abstracta.jmeter.javadsl.core.stats.CountMetricSummary;
import us.abstracta.jmeter.javadsl.core.stats.StatsSummary;
import us.abstracta.jmeter.javadsl.core.stats.TimeMetricSummary;

public class EmbeddedStatsSummary
implements StatsSummary {
    private long firstTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;
    private final CountMetricSummary samples = new CountMetricSummary();
    private final CountMetricSummary errors = new CountMetricSummary();
    private final CountMetricSummary receivedBytes = new CountMetricSummary();
    private final CountMetricSummary sentBytes = new CountMetricSummary();
    private final EmbeddedTimeMetricSummary sampleTime = new EmbeddedTimeMetricSummary();

    @Override
    public void add(SampleResult result) {
        this.firstTime = Math.min(this.firstTime, result.getStartTime());
        this.endTime = Math.max(this.endTime, result.getEndTime());
        long elapsedTimeMillis = this.endTime - this.firstTime;
        this.samples.increment(1L, elapsedTimeMillis);
        if (!result.isSuccessful()) {
            this.errors.increment(1L, elapsedTimeMillis);
        }
        this.receivedBytes.increment(result.getBytesAsLong(), elapsedTimeMillis);
        this.sentBytes.increment(result.getSentBytes(), elapsedTimeMillis);
        this.sampleTime.add(result.getTime());
    }

    @Override
    public Instant firstTime() {
        return Instant.ofEpochMilli(this.firstTime);
    }

    @Override
    public Instant endTime() {
        return Instant.ofEpochMilli(this.endTime);
    }

    @Override
    public CountMetricSummary samples() {
        return this.samples;
    }

    @Override
    public CountMetricSummary errors() {
        return this.errors;
    }

    @Override
    public TimeMetricSummary sampleTime() {
        return this.sampleTime;
    }

    @Override
    public CountMetricSummary receivedBytes() {
        return this.receivedBytes;
    }

    @Override
    public CountMetricSummary sentBytes() {
        return this.sentBytes;
    }

    public static class EmbeddedTimeMetricSummary
    implements TimeMetricSummary {
        private final PSquarePercentile median = new PSquarePercentile(50.0);
        private final PSquarePercentile percentile90 = new PSquarePercentile(90.0);
        private final PSquarePercentile percentile95 = new PSquarePercentile(95.0);
        private final PSquarePercentile percentile99 = new PSquarePercentile(99.0);
        private long min = Long.MAX_VALUE;
        private long max = Long.MIN_VALUE;
        private final Mean mean = new Mean();

        public void add(long val) {
            this.min = Math.min(this.min, val);
            this.max = Math.max(this.max, val);
            this.median.increment((double)val);
            this.percentile90.increment((double)val);
            this.percentile95.increment((double)val);
            this.percentile99.increment((double)val);
            this.mean.increment((double)val);
        }

        @Override
        public Duration min() {
            return Duration.ofMillis(this.min);
        }

        @Override
        public Duration max() {
            return Duration.ofMillis(this.max);
        }

        @Override
        public Duration mean() {
            return this.double2Duration(this.mean.getResult());
        }

        private Duration double2Duration(double millis) {
            return Duration.ofMillis(Math.round(millis));
        }

        @Override
        public Duration median() {
            return this.double2Duration(this.median.getResult());
        }

        @Override
        public Duration perc90() {
            return this.double2Duration(this.percentile90.getResult());
        }

        @Override
        public Duration perc95() {
            return this.double2Duration(this.percentile95.getResult());
        }

        @Override
        public Duration perc99() {
            return this.double2Duration(this.percentile99.getResult());
        }
    }
}

