/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.control.gui.TestPlanGui;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.engines.EmbeddedJmeterEngine;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;
import us.abstracta.jmeter.javadsl.core.engines.JmeterGui;
import us.abstracta.jmeter.javadsl.core.testelements.TestElementContainer;

public class DslTestPlan
extends TestElementContainer<TestPlanChild> {
    private boolean tearDownAfterMainThreadsShutDown = true;
    private boolean serializeThreadGroups = false;

    public DslTestPlan(List<TestPlanChild> children) {
        super("Test Plan", TestPlanGui.class, children);
    }

    public DslTestPlan sequentialThreadGroups() {
        this.serializeThreadGroups = true;
        return this;
    }

    public DslTestPlan tearDownOnlyAfterMainThreadsDone() {
        this.tearDownAfterMainThreadsShutDown = false;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        TestPlan ret = new TestPlan();
        ret.setUserDefinedVariables(new Arguments());
        ret.setTearDownOnShutdown(this.tearDownAfterMainThreadsShutDown);
        ret.setSerialized(this.serializeThreadGroups);
        return ret;
    }

    public TestPlanStats run() throws IOException {
        return new EmbeddedJmeterEngine().run(this);
    }

    public TestPlanStats runIn(DslJmeterEngine engine) throws IOException, InterruptedException, TimeoutException {
        return engine.run(this);
    }

    @Override
    public void showInGui() {
        try {
            ListedHashTree tree = new ListedHashTree();
            new BuildTreeContext().buildTreeFor(this, (HashTree)tree);
            JmeterEnvironment env = new JmeterEnvironment();
            env.initLocale();
            env.updateSearchPath((HashTree)tree);
            JmeterGui gui = new JmeterGui();
            gui.load((HashTree)tree);
            gui.awaitClose();
        }
        catch (IOException | IllegalUserActionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void saveAsJmx(String filePath) throws IOException {
        JmeterEnvironment env = new JmeterEnvironment();
        try (FileOutputStream output = new FileOutputStream(filePath);){
            ListedHashTree tree = new ListedHashTree();
            new BuildTreeContext().buildTreeFor(this, (HashTree)tree);
            env.saveTree((HashTree)tree, output);
        }
    }

    public static DslTestPlan fromJmx(String filePath) throws IOException {
        JmeterEnvironment env = new JmeterEnvironment();
        HashTree tree = env.loadTree(new File(filePath));
        return new JmxTestPlan(tree);
    }

    public static class CodeBuilder
    extends SingleTestElementCallBuilder<TestPlan> {
        public CodeBuilder(List<Method> builderMethods) {
            super(TestPlan.class, builderMethods);
        }

        @Override
        protected MethodCall buildMethodCall(TestPlan testElement, MethodCallContext context) {
            TestElementParamBuilder paramBuilder = new TestElementParamBuilder((TestElement)testElement, "TestPlan");
            return this.buildMethodCall(new MethodParam.ChildrenParam<TestPlanChild[]>(TestPlanChild[].class)).chain("sequentialThreadGroups", paramBuilder.boolParam("serialize_threadgroups", false)).chain("tearDownOnlyAfterMainThreadsDone", paramBuilder.boolParam("tearDown_on_shutdown", true));
        }
    }

    public static interface TestPlanChild
    extends DslTestElement {
    }

    private static class JmxTestPlan
    extends DslTestPlan {
        private final HashTree tree;

        private JmxTestPlan(HashTree tree) {
            super(Collections.emptyList());
            this.tree = tree;
        }

        @Override
        public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
            parent.putAll((Map)this.tree);
            return (HashTree)parent.values().iterator().next();
        }
    }
}

