/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.slf4j.Logger;
import us.abstracta.jmeter.javadsl.core.util.DslScriptBuilder;

public class PropertyScriptBuilder
extends DslScriptBuilder {
    public PropertyScriptBuilder(String script) {
        super(script);
    }

    public PropertyScriptBuilder(PropertyScript script) {
        super(script, PropertyScriptVars.class, PropertyScriptBuilder.buildVarsMapping());
    }

    private static Map<String, String> buildVarsMapping() {
        HashMap<String, String> ret = new HashMap<String, String>();
        PropertyScriptBuilder.addOptionalVarMapping("prev", ret);
        PropertyScriptBuilder.addOptionalVarMapping("sampler", ret);
        return ret;
    }

    private static void addOptionalVarMapping(String varName, HashMap<String, String> ret) {
        ret.put(varName, "binding.hasVariable('" + varName + "') ? " + varName + " : null");
    }

    @Override
    public String build() {
        return this.scriptString != null ? this.scriptString : "${__groovy(" + super.build().replace(",", "\\,") + ")}";
    }

    public static class PropertyScriptVars
    extends DslScriptBuilder.DslScriptVars {
        public final String threadName;

        public PropertyScriptVars(String threadName, SampleResult prev, JMeterContext ctx, JMeterVariables vars, Properties props, Sampler sampler, Logger log) {
            super(prev, ctx, vars, props, sampler, log);
            this.threadName = threadName;
        }
    }

    public static interface PropertyScript
    extends DslScriptBuilder.DslScript<PropertyScriptVars, Boolean> {
    }
}

