/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.assertions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jmeter.assertions.ResponseAssertion;
import org.apache.jmeter.assertions.gui.AssertionGui;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.testelements.DslScopedTestElement;
import us.abstracta.jmeter.javadsl.core.testelements.MultiLevelTestElement;

public class DslResponseAssertion
extends DslScopedTestElement<DslResponseAssertion>
implements MultiLevelTestElement {
    private TargetField fieldToTest = TargetField.RESPONSE_BODY;
    private boolean ignoreStatus;
    private List<String> testStrings = new ArrayList<String>();
    private TestStringStrategy testStrategy = TestStringStrategy.SUBSTRING;
    private boolean invertCheck;
    private boolean anyMatch;

    public DslResponseAssertion(String name) {
        super(name != null ? name : "Response Assertion", AssertionGui.class);
    }

    public DslResponseAssertion fieldToTest(TargetField fieldToTest) {
        this.fieldToTest = fieldToTest;
        return this;
    }

    public DslResponseAssertion ignoreStatus() {
        this.ignoreStatus = true;
        return this;
    }

    public DslResponseAssertion containsSubstrings(String ... substrings) {
        return this.testStrings(substrings, TestStringStrategy.SUBSTRING);
    }

    private DslResponseAssertion testStrings(String[] testStrings, TestStringStrategy strategy) {
        this.testStrings = Arrays.asList(testStrings);
        this.testStrategy = strategy;
        return this;
    }

    public DslResponseAssertion equalsToStrings(String ... strings) {
        return this.testStrings(strings, TestStringStrategy.EQUALS);
    }

    public DslResponseAssertion containsRegexes(String ... regexes) {
        return this.testStrings(regexes, TestStringStrategy.CONTAINS_REGEX);
    }

    public DslResponseAssertion matchesRegexes(String ... regexes) {
        return this.testStrings(regexes, TestStringStrategy.MATCHES_REGEX);
    }

    public DslResponseAssertion invertCheck() {
        this.invertCheck = !this.invertCheck;
        return this;
    }

    public DslResponseAssertion anyMatch() {
        this.anyMatch = true;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        ResponseAssertion ret = new ResponseAssertion();
        this.setScopeTo((AbstractScopedTestElement)ret);
        this.fieldToTest.applyTo(ret);
        ret.setAssumeSuccess(this.ignoreStatus);
        if (this.invertCheck) {
            ret.setToNotType();
        }
        if (this.anyMatch) {
            ret.setToOrType();
        }
        this.testStrategy.applyTo(ret);
        this.testStrings.forEach(arg_0 -> ((ResponseAssertion)ret).addTestString(arg_0));
        return ret;
    }

    private static enum TestStringStrategy {
        CONTAINS_REGEX(ResponseAssertion::setToContainsType),
        MATCHES_REGEX(ResponseAssertion::setToMatchType),
        SUBSTRING(ResponseAssertion::setToSubstringType),
        EQUALS(ResponseAssertion::setToEqualsType);

        private final Consumer<ResponseAssertion> applier;

        private TestStringStrategy(Consumer<ResponseAssertion> applier) {
            this.applier = applier;
        }

        private void applyTo(ResponseAssertion assertion) {
            this.applier.accept(assertion);
        }
    }

    public static enum TargetField {
        RESPONSE_BODY(ResponseAssertion::setTestFieldResponseData),
        RESPONSE_BODY_AS_DOCUMENT(ResponseAssertion::setTestFieldResponseDataAsDocument),
        RESPONSE_CODE(ResponseAssertion::setTestFieldResponseCode),
        RESPONSE_MESSAGE(ResponseAssertion::setTestFieldResponseMessage),
        RESPONSE_HEADERS(ResponseAssertion::setTestFieldResponseHeaders),
        REQUEST_HEADERS(ResponseAssertion::setTestFieldRequestHeaders),
        REQUEST_URL(ResponseAssertion::setTestFieldURL),
        REQUEST_BODY(ResponseAssertion::setTestFieldRequestData);

        private final Consumer<ResponseAssertion> applier;

        private TargetField(Consumer<ResponseAssertion> applier) {
            this.applier = applier;
        }

        private void applyTo(ResponseAssertion assertion) {
            this.applier.accept(assertion);
        }
    }
}

