/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.listeners;

import java.io.File;
import java.nio.file.FileAlreadyExistsException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.SimpleDataWriter;
import us.abstracta.jmeter.javadsl.core.testelements.BaseTestElement;
import us.abstracta.jmeter.javadsl.core.testelements.MultiLevelTestElement;

public class JtlWriter
extends BaseTestElement
implements MultiLevelTestElement {
    private final String jtlFile;
    private boolean saveAsXml;
    private boolean saveElapsedTime = true;
    private boolean saveResponseMessage = true;
    private boolean saveSuccess = true;
    private boolean saveSentByteCount = true;
    private boolean saveResponseFilename;
    private boolean saveEncoding;
    private boolean saveIdleTime = true;
    private boolean saveResponseHeaders;
    private boolean saveAssertionResults = true;
    private boolean saveFieldNames = true;
    private boolean saveLabel = true;
    private boolean saveThreadName = true;
    private boolean saveAssertionFailureMessage = true;
    private boolean saveActiveThreadCounts = true;
    private boolean saveLatency = true;
    private boolean saveSampleAndErrorCounts;
    private boolean saveRequestHeaders;
    private boolean saveResponseData;
    private boolean saveTimeStamp = true;
    private boolean saveResponseCode = true;
    private boolean saveDataType = true;
    private boolean saveReceivedByteCount = true;
    private boolean saveUrl = true;
    private boolean saveConnectTime = true;
    private boolean saveHostname;
    private boolean saveSamplerData;
    private boolean saveSubResults = true;
    private boolean overwriteJtl = false;
    private List<String> sampleVariables = Collections.emptyList();

    public JtlWriter(String jtlFile) {
        super("Simple Data Writer", SimpleDataWriter.class);
        this.jtlFile = jtlFile;
    }

    @Override
    public TestElement buildTestElement() {
        File file = new File(this.jtlFile);
        if (file.exists()) {
            if (this.overwriteJtl) {
                file.delete();
            } else {
                throw new IllegalArgumentException(new FileAlreadyExistsException(this.jtlFile));
            }
        }
        ResultCollector logger = new ResultCollector();
        logger.setFilename(this.jtlFile);
        SampleSaveConfiguration config = logger.getSaveConfig();
        config.setAsXml(this.saveAsXml);
        config.setTime(this.saveElapsedTime);
        config.setMessage(this.saveResponseMessage);
        config.setSuccess(this.saveSuccess);
        config.setSentBytes(this.saveSentByteCount);
        config.setFileName(this.saveResponseFilename);
        config.setEncoding(this.saveEncoding);
        config.setIdleTime(this.saveIdleTime);
        config.setResponseHeaders(this.saveResponseHeaders);
        config.setAssertions(this.saveAssertionResults);
        config.setFieldNames(this.saveFieldNames);
        config.setLabel(this.saveLabel);
        config.setThreadName(this.saveThreadName);
        config.setAssertionResultsFailureMessage(this.saveAssertionFailureMessage);
        config.setThreadCounts(this.saveActiveThreadCounts);
        config.setLatency(this.saveLatency);
        config.setSampleCount(this.saveSampleAndErrorCounts);
        config.setRequestHeaders(this.saveRequestHeaders);
        config.setResponseData(this.saveResponseData);
        config.setTimestamp(this.saveTimeStamp);
        config.setCode(this.saveResponseCode);
        config.setDataType(this.saveDataType);
        config.setBytes(this.saveReceivedByteCount);
        config.setUrl(this.saveUrl);
        config.setConnectTime(this.saveConnectTime);
        config.setHostname(this.saveHostname);
        config.setSamplerData(this.saveSamplerData);
        config.setSubresults(this.saveSubResults);
        if (!this.sampleVariables.isEmpty()) {
            JMeterUtils.setProperty((String)"sample_variables", (String)String.join((CharSequence)",", this.sampleVariables));
        }
        return logger;
    }

    public JtlWriter withAllFields(boolean enabled) {
        this.saveAsXml = enabled;
        this.saveElapsedTime = enabled;
        this.saveResponseMessage = enabled;
        this.saveSuccess = enabled;
        this.saveSentByteCount = enabled;
        this.saveResponseFilename = enabled;
        this.saveEncoding = enabled;
        this.saveIdleTime = enabled;
        this.saveResponseHeaders = enabled;
        this.saveAssertionResults = enabled;
        this.saveFieldNames = enabled;
        this.saveLabel = enabled;
        this.saveThreadName = enabled;
        this.saveAssertionFailureMessage = enabled;
        this.saveActiveThreadCounts = enabled;
        this.saveLatency = enabled;
        this.saveSampleAndErrorCounts = enabled;
        this.saveRequestHeaders = enabled;
        this.saveResponseData = enabled;
        this.saveTimeStamp = enabled;
        this.saveResponseCode = enabled;
        this.saveDataType = enabled;
        this.saveReceivedByteCount = enabled;
        this.saveUrl = enabled;
        this.saveConnectTime = enabled;
        this.saveHostname = enabled;
        this.saveSamplerData = enabled;
        this.saveSubResults = enabled;
        return this;
    }

    public JtlWriter saveAsXml(boolean enabled) {
        this.saveAsXml = enabled;
        return this;
    }

    public JtlWriter withElapsedTime(boolean enabled) {
        this.saveElapsedTime = enabled;
        return this;
    }

    public JtlWriter withResponseMessage(boolean enabled) {
        this.saveResponseMessage = enabled;
        return this;
    }

    public JtlWriter withSuccess(boolean enabled) {
        this.saveSuccess = enabled;
        return this;
    }

    public JtlWriter withSentByteCount(boolean enabled) {
        this.saveSentByteCount = enabled;
        return this;
    }

    public JtlWriter withResponseFilename(boolean enabled) {
        this.saveResponseFilename = enabled;
        return this;
    }

    public JtlWriter withEncoding(boolean enabled) {
        this.saveEncoding = enabled;
        return this;
    }

    public JtlWriter withIdleTime(boolean enabled) {
        this.saveIdleTime = enabled;
        return this;
    }

    public JtlWriter withResponseHeaders(boolean enabled) {
        this.saveResponseHeaders = enabled;
        return this;
    }

    public JtlWriter withAssertionResults(boolean enabled) {
        this.saveAssertionResults = enabled;
        return this;
    }

    public JtlWriter withFieldNames(boolean enabled) {
        this.saveFieldNames = enabled;
        return this;
    }

    public JtlWriter withLabel(boolean enabled) {
        this.saveLabel = enabled;
        return this;
    }

    public JtlWriter withThreadName(boolean enabled) {
        this.saveThreadName = enabled;
        return this;
    }

    public JtlWriter withAssertionFailureMessage(boolean enabled) {
        this.saveAssertionFailureMessage = enabled;
        return this;
    }

    public JtlWriter withActiveThreadCounts(boolean enabled) {
        this.saveActiveThreadCounts = enabled;
        return this;
    }

    public JtlWriter withLatency(boolean enabled) {
        this.saveLatency = enabled;
        return this;
    }

    public JtlWriter withSampleAndErrorCounts(boolean enabled) {
        this.saveSampleAndErrorCounts = enabled;
        return this;
    }

    public JtlWriter withRequestHeaders(boolean enabled) {
        this.saveRequestHeaders = enabled;
        return this;
    }

    public JtlWriter withResponseData(boolean enabled) {
        this.saveResponseData = enabled;
        return this;
    }

    public JtlWriter withTimeStamp(boolean enabled) {
        this.saveTimeStamp = enabled;
        return this;
    }

    public JtlWriter withResponseCode(boolean enabled) {
        this.saveResponseCode = enabled;
        return this;
    }

    public JtlWriter withDataType(boolean enabled) {
        this.saveDataType = enabled;
        return this;
    }

    public JtlWriter withReceivedByteCount(boolean enabled) {
        this.saveReceivedByteCount = enabled;
        return this;
    }

    public JtlWriter withUrl(boolean enabled) {
        this.saveUrl = enabled;
        return this;
    }

    public JtlWriter withConnectTime(boolean enabled) {
        this.saveConnectTime = enabled;
        return this;
    }

    public JtlWriter withHostname(boolean enabled) {
        this.saveHostname = enabled;
        return this;
    }

    public JtlWriter withSamplerData(boolean enabled) {
        this.saveSamplerData = enabled;
        return this;
    }

    public JtlWriter withSubResults(boolean enabled) {
        this.saveSubResults = enabled;
        return this;
    }

    public JtlWriter overwriteJtl() {
        this.overwriteJtl = true;
        return this;
    }

    public JtlWriter withVariables(String ... variables) {
        this.sampleVariables = Arrays.asList(variables);
        return this;
    }
}

