/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.testelements;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.function.Supplier;
import javax.swing.JFrame;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testbeans.BeanInfoSupport;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;

public abstract class BaseTestElement
implements DslTestElement {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTestElement.class);
    protected final String name;
    protected Class<? extends JMeterGUIComponent> guiClass;

    protected BaseTestElement(String name, Class<? extends JMeterGUIComponent> guiClass) {
        this.name = name;
        this.guiClass = guiClass;
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        return parent.add((Object)this.buildConfiguredTestElement());
    }

    protected TestElement buildConfiguredTestElement() {
        TestElement ret = this.buildTestElement();
        return BaseTestElement.configureTestElement(ret, this.name, this.guiClass, this.getBeanInfo());
    }

    protected static TestElement configureTestElement(TestElement ret, String name, Class<? extends JMeterGUIComponent> guiClass, BeanInfoSupport beanInfo) {
        ret.setName(name);
        ret.setProperty("TestElement.gui_class", guiClass.getName());
        ret.setProperty("TestElement.test_class", ret.getClass().getName());
        if (beanInfo != null) {
            BaseTestElement.loadBeanProperties(ret, beanInfo);
        }
        return ret;
    }

    protected abstract TestElement buildTestElement();

    protected BeanInfoSupport getBeanInfo() {
        return null;
    }

    private static void loadBeanProperties(TestElement bean, BeanInfoSupport beanInfo) {
        for (PropertyDescriptor prop : beanInfo.getPropertyDescriptors()) {
            if (TestBeanHelper.isDescriptorIgnored((PropertyDescriptor)prop)) continue;
            try {
                JMeterProperty jprop = AbstractProperty.createProperty((Object)prop.getReadMethod().invoke((Object)bean, new Object[0]));
                jprop.setName(prop.getName());
                bean.setProperty(jprop);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("Could not set property {} for bean {}", (Object)prop.getName(), (Object)bean);
            }
        }
    }

    @Override
    public void showInGui() {
        try (JmeterEnvironment env = new JmeterEnvironment();){
            env.initLocale();
            this.showTestElementGui(() -> this.buildTestElementGui(this.buildConfiguredTestElement()), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Component buildTestElementGui(TestElement testElement) {
        try {
            Class<?> guiClass = Class.forName(testElement.getPropertyAsString("TestElement.gui_class"));
            TestBeanGUI gui = guiClass == TestBeanGUI.class ? new TestBeanGUI(testElement.getClass()) : (JMeterGUIComponent)guiClass.newInstance();
            gui.clearGui();
            gui.configure(testElement);
            gui.modifyTestElement(testElement);
            return (Component)gui;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void showTestElementGui(Supplier<Component> guiBuilder, Runnable closeListener) {
        this.showFrameWith(guiBuilder.get(), this.name, 800, 600, closeListener);
    }

    protected void showFrameWith(Component content, String title, int width, int height, final Runnable closeListener) {
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(closeListener != null ? 2 : 3);
        if (closeListener != null) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                    closeListener.run();
                }
            });
        }
        frame.setLocation(200, 200);
        frame.setSize(width, height);
        frame.add(content);
        frame.setVisible(true);
    }

    protected static long durationToSeconds(Duration duration) {
        return Math.round(Math.ceil((double)duration.toMillis() / 1000.0));
    }
}

