/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.engines;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.jmeter.engine.DistributedRunner;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.engines.AggregatingTestPlanStats;
import us.abstracta.jmeter.javadsl.core.engines.EmbeddedJmeterEngine;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;

public class DistributedJmeterEngine
extends EmbeddedJmeterEngine {
    private final List<String> hosts;
    private int basePort;
    private boolean stopEngines;
    private JmeterEnvironment jmeterEnv;

    public DistributedJmeterEngine(String ... hosts) {
        this.hosts = Arrays.asList(hosts);
    }

    public DistributedJmeterEngine localBasePort(int basePort) {
        this.basePort = basePort;
        return this;
    }

    public DistributedJmeterEngine stopEnginesOnTestEnd() {
        this.stopEngines = true;
        return this;
    }

    protected DistributedJmeterEngine localJMeterEnv(JmeterEnvironment env) {
        this.jmeterEnv = env;
        return this;
    }

    @Override
    public TestPlanStats run(DslTestPlan testPlan) throws IOException {
        if (this.jmeterEnv != null) {
            return this.runInEnv(testPlan, this.jmeterEnv);
        }
        try (JmeterEnvironment env = new JmeterEnvironment();){
            TestPlanStats testPlanStats = this.runInEnv(testPlan, env);
            return testPlanStats;
        }
    }

    @Override
    protected void addStatsCollector(HashTree testPlanTree, AggregatingTestPlanStats stats) {
        testPlanTree.add((Object)new StatsCollector(stats));
    }

    @Override
    protected Runnable buildTestRunner(HashTree testPlanTree, HashTree rootTree) {
        JMeterUtils.setProperty((String)"client.rmi.localport", (String)String.valueOf(this.basePort));
        EnginesEndListener endListener = new EnginesEndListener(this.stopEngines);
        testPlanTree.add((Object)endListener);
        DistributedRunner distributedRunner = new DistributedRunner();
        distributedRunner.setStdout(System.out);
        distributedRunner.setStdErr(System.err);
        distributedRunner.init(this.hosts, rootTree);
        endListener.setStartedRemoteEngines(new ArrayList<JMeterEngine>(distributedRunner.getEngines()));
        return () -> {
            distributedRunner.start();
            try {
                endListener.await();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        };
    }

    private static class EnginesEndListener
    implements TestStateListener,
    Remoteable {
        private static final Logger LOG = LoggerFactory.getLogger(EnginesEndListener.class);
        private final boolean stopEngines;
        private CountDownLatch runningEngines;
        private List<JMeterEngine> remoteEngines;

        private EnginesEndListener(boolean stopEngines) {
            this.stopEngines = stopEngines;
        }

        public void setStartedRemoteEngines(List<JMeterEngine> engines) {
            this.remoteEngines = engines;
            this.runningEngines = new CountDownLatch(engines.size());
        }

        public void testEnded(String host) {
            long now = System.currentTimeMillis();
            LOG.info("Finished remote host: {} ({})", (Object)host, (Object)now);
            this.runningEngines.countDown();
            if (this.stopEngines && this.runningEngines.getCount() <= 0L) {
                for (JMeterEngine engine : this.remoteEngines) {
                    engine.exit();
                }
            }
        }

        public void testEnded() {
        }

        public void testStarted(String host) {
            LOG.info("Started remote host:  {} ({})", (Object)host, (Object)System.currentTimeMillis());
        }

        public void testStarted() {
        }

        public void await() throws InterruptedException {
            this.runningEngines.await();
        }
    }

    private static class StatsCollector
    implements SampleListener,
    Remoteable {
        private final AggregatingTestPlanStats stats;

        private StatsCollector(AggregatingTestPlanStats stats) {
            this.stats = stats;
        }

        public void sampleOccurred(SampleEvent e) {
            this.stats.addSampleResult(e.getResult());
        }

        public void sampleStarted(SampleEvent e) {
        }

        public void sampleStopped(SampleEvent e) {
        }
    }
}

