/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.awt.Component;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kg.apc.jmeter.timers.functions.TSTFeedback;
import org.apache.commons.io.FileUtils;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.functions.EvalFunction;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.core.AggregatingTestPlanStats;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.listeners.DslVisualizer;

public class EmbeddedJmeterEngine
implements DslJmeterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedJmeterEngine.class);

    @Override
    public TestPlanStats run(DslTestPlan testPlan) throws IOException {
        try (JMeterEnvironment env = new JMeterEnvironment();){
            StandardJMeterEngine engine = new StandardJMeterEngine();
            ListedHashTree rootTree = new ListedHashTree();
            BuildTreeContext buildContext = new BuildTreeContext((HashTree)rootTree);
            HashTree testPlanTree = testPlan.buildTreeUnder((HashTree)rootTree, buildContext);
            AggregatingTestPlanStats stats = new AggregatingTestPlanStats();
            this.addTestStatsCollectorToTree(stats, testPlanTree);
            this.addTestSummariserToTree(testPlanTree);
            engine.configure((HashTree)rootTree);
            List<Future<Void>> closedVisualizers = Collections.emptyList();
            if (!buildContext.getVisualizers().isEmpty()) {
                env.initLocale();
                closedVisualizers = this.showVisualizers(buildContext.getVisualizers());
            }
            stats.setStart(Instant.now());
            engine.run();
            stats.setEnd(Instant.now());
            this.awaitAllClosedVisualizers(closedVisualizers);
            AggregatingTestPlanStats aggregatingTestPlanStats = stats;
            return aggregatingTestPlanStats;
        }
    }

    private List<Future<Void>> showVisualizers(Map<DslVisualizer, Supplier<Component>> visualizers) {
        return visualizers.entrySet().stream().map(e -> {
            CompletableFuture closedVisualizer = new CompletableFuture();
            ((DslVisualizer)e.getKey()).showTestElementGui((Supplier)e.getValue(), () -> closedVisualizer.complete(null));
            return closedVisualizer;
        }).collect(Collectors.toList());
    }

    public void awaitAllClosedVisualizers(List<Future<Void>> closedVisualizers) {
        try {
            for (Future<Void> closedVisualizer : closedVisualizers) {
                try {
                    closedVisualizer.get();
                }
                catch (ExecutionException e) {
                    LOG.warn("Problem waiting for a visualizer to close", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private void addTestStatsCollectorToTree(final AggregatingTestPlanStats stats, HashTree tree) {
        ResultCollector collector = new ResultCollector();
        Visualizer statsVisualizer = new Visualizer(){

            public void add(SampleResult r) {
                stats.addSampleResult(r);
            }

            public boolean isStats() {
                return true;
            }
        };
        collector.setListener(statsVisualizer);
        tree.add((Object)collector);
        tree.add((Object)statsVisualizer);
    }

    private void addTestSummariserToTree(HashTree tree) {
        tree.add((Object)new ResultCollector(new Summariser()));
    }

    public static class JMeterEnvironment
    implements Closeable {
        private final File homeDir = Files.createTempDirectory("jmeter-java-dsl", new FileAttribute[0]).toFile();

        public JMeterEnvironment() throws IOException {
            try {
                JMeterUtils.setJMeterHome((String)this.homeDir.getPath());
                File binDir = new File(this.homeDir, "bin");
                this.installConfig(binDir);
                Properties props = JMeterUtils.getProperties((String)new File(binDir, "jmeter.properties").getPath());
                props.setProperty("search_paths", this.buildJarPathsFromClasses(EvalFunction.class, BackendListenerClient.class, TSTFeedback.class));
            }
            catch (IOException | RuntimeException e) {
                FileUtils.deleteDirectory((File)this.homeDir);
                throw e;
            }
        }

        private String buildJarPathsFromClasses(Class<?> ... classes) {
            return Arrays.stream(classes).map(this::getClassJarPath).collect(Collectors.joining(";"));
        }

        private String getClassJarPath(Class<?> theClass) {
            try {
                return new File(theClass.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private void installConfig(File binDir) throws IOException {
            try (FileSystem fs = FileSystems.newFileSystem(this.getClass().getResource("/bin/jmeter.properties").toURI(), Collections.emptyMap());){
                Path configBinDir = fs.getPath("/bin", new String[0]);
                for (Path p : Files.walk(configBinDir, new FileVisitOption[0])::iterator) {
                    Path targetPath = binDir.toPath().resolve(configBinDir.relativize(p).toString());
                    Files.copy(p, targetPath, new CopyOption[0]);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public void saveTree(HashTree tree, FileOutputStream output) throws IOException {
            SaveService.saveTree((HashTree)tree, (OutputStream)output);
        }

        public HashTree loadTree(File file) throws IOException {
            return SaveService.loadTree((File)file);
        }

        public void initLocale() {
            JMeterUtils.initLocale();
        }

        @Override
        public void close() throws IOException {
            FileUtils.deleteDirectory((File)this.homeDir);
        }
    }
}

