/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.util.function.Consumer;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import us.abstracta.jmeter.javadsl.core.BaseTestElement;

public abstract class DslScopedTestElement<T>
extends BaseTestElement {
    private Scope scope = Scope.MAIN_SAMPLE;
    private String scopeVariable;

    protected DslScopedTestElement(String name, Class<? extends JMeterGUIComponent> guiClass) {
        super(name, guiClass);
    }

    public T scope(Scope scope) {
        this.scope = scope;
        return (T)this;
    }

    public T scopeVariable(String scopeVariable) {
        this.scopeVariable = scopeVariable;
        return (T)this;
    }

    protected void setScopeTo(AbstractScopedTestElement testElement) {
        this.scope.applyTo(testElement);
        if (this.scopeVariable != null) {
            testElement.setScopeVariable(this.scopeVariable);
        }
    }

    public static enum Scope {
        ALL_SAMPLES(AbstractScopedTestElement::setScopeAll),
        MAIN_SAMPLE(AbstractScopedTestElement::setScopeParent),
        SUB_SAMPLES(AbstractScopedTestElement::setScopeChildren);

        private final Consumer<AbstractScopedTestElement> applier;

        private Scope(Consumer<AbstractScopedTestElement> applier) {
            this.applier = applier;
        }

        private void applyTo(AbstractScopedTestElement re) {
            this.applier.accept(re);
        }
    }
}

