/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.postprocessors;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.jmeter.extractor.JSR223PostProcessor;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JSR223TestElement;
import org.slf4j.Logger;
import us.abstracta.jmeter.javadsl.core.DslJsr223TestElement;
import us.abstracta.jmeter.javadsl.core.MultiLevelTestElement;

public class DslJsr223PostProcessor
extends DslJsr223TestElement
implements MultiLevelTestElement {
    private static final String DEFAULT_NAME = "JSR223 PostProcessor";

    public DslJsr223PostProcessor(String name, String script) {
        super(name, DEFAULT_NAME, script);
    }

    public DslJsr223PostProcessor(String name, PostProcessorScript script) {
        super(name, DEFAULT_NAME, script, PostProcessorVars.class);
    }

    @Override
    protected JSR223TestElement buildJsr223TestElement() {
        return new JSR223PostProcessor();
    }

    public static class PostProcessorVars
    extends DslJsr223TestElement.Jsr223ScriptVars {
        public SampleResult prev;

        public PostProcessorVars(SampleResult prev, JMeterContext ctx, JMeterVariables vars, Properties props, Sampler sampler, Logger log, String label) {
            super(ctx, vars, props, sampler, log, label);
            this.prev = prev;
        }

        public Map<String, Object> prevMap() {
            Map<String, Object> ret = this.prevMetadata();
            ret.putAll(this.prevMetrics());
            ret.put("request", this.prevRequest());
            ret.put("response", this.prevResponse());
            return ret;
        }

        public Map<String, Object> prevMetadata() {
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            ret.put("label", this.prev.getSampleLabel());
            ret.put("timestamp", Instant.ofEpochMilli(this.prev.getTimeStamp()));
            SampleResult parent = this.prev.getParent();
            if (parent != null) {
                ret.put("parent", parent.getSampleLabel());
            }
            ret.put("successful", this.prev.isSuccessful());
            ret.put("threadName", this.prev.getThreadName());
            ret.put("threadsCount", this.prev.getAllThreads());
            ret.put("threadGroupSize", this.prev.getGroupThreads());
            return ret;
        }

        public Map<String, Object> prevMetrics() {
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            ret.put("sampleMillis", this.prev.getTime());
            ret.put("connectionMillis", this.prev.getConnectTime());
            ret.put("latencyMillis", this.prev.getLatency());
            ret.put("sentBytes", this.prev.getSentBytes());
            ret.put("receivedBytes", this.prev.getBytesAsLong());
            return ret;
        }

        public String prevRequest() {
            return this.prev instanceof HTTPSampleResult ? this.httpRequestString((HTTPSampleResult)this.prev) : this.prev.getRequestHeaders() + "\n" + this.prev.getSamplerData();
        }

        private String httpRequestString(HTTPSampleResult result) {
            String cookiesHeader = result.getCookies();
            if (cookiesHeader != null && !cookiesHeader.isEmpty()) {
                cookiesHeader = "Cookie: " + cookiesHeader + "\n";
            }
            return result.getHTTPMethod() + " " + result.getUrlAsString() + "\n" + result.getRequestHeaders() + cookiesHeader + "\n" + result.getQueryString();
        }

        public String prevResponse() {
            String statusLine = this.prev instanceof HTTPSampleResult ? "" : this.prev.getResponseCode() + " " + this.prev.getResponseMessage() + "\n";
            return statusLine + this.prev.getResponseHeaders() + "\n" + this.prev.getResponseDataAsString();
        }
    }

    public static interface PostProcessorScript
    extends DslJsr223TestElement.Jsr223Script<PostProcessorVars> {
    }
}

