/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.awt.Component;
import java.io.IOException;
import javax.swing.JFrame;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.EmbeddedJmeterEngine;

public abstract class BaseTestElement
implements DslTestElement {
    protected final String name;
    protected Class<? extends JMeterGUIComponent> guiClass;

    protected BaseTestElement(String name, Class<? extends JMeterGUIComponent> guiClass) {
        this.name = name;
        this.guiClass = guiClass;
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        TestElement testElement = this.buildTestElement();
        testElement.setName(this.name);
        testElement.setProperty("TestElement.gui_class", this.guiClass.getName());
        testElement.setProperty("TestElement.test_class", testElement.getClass().getName());
        return parent.add((Object)testElement);
    }

    @Override
    public void showInGui() {
        try (EmbeddedJmeterEngine.JMeterEnvironment env = new EmbeddedJmeterEngine.JMeterEnvironment();){
            env.initLocale();
            TestElement testElement = this.buildTestElement();
            testElement.setName(this.name);
            TestBeanGUI gui = this.guiClass == TestBeanGUI.class ? new TestBeanGUI(testElement.getClass()) : this.guiClass.newInstance();
            gui.configure(testElement);
            this.showFrameWith((Component)gui, 800, 600);
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void showFrameWith(Component content, int width, int height) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setLocation(200, 200);
        frame.setSize(width, height);
        frame.add(content);
        frame.setVisible(true);
    }

    protected abstract TestElement buildTestElement();
}

