/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.postprocessors;

import java.util.function.Consumer;
import org.apache.jmeter.extractor.RegexExtractor;
import org.apache.jmeter.extractor.gui.RegexExtractorGui;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.BaseTestElement;
import us.abstracta.jmeter.javadsl.core.MultiScopedTestElement;

public class DslRegexExtractor
extends BaseTestElement
implements MultiScopedTestElement {
    private final String variableName;
    private final String regex;
    private int matchNumber = 1;
    private String template = "$1$";
    private String defaultValue;
    private TargetField fieldToCheck = TargetField.RESPONSE_BODY;
    private Scope scope = Scope.MAIN_SAMPLE;
    private String scopeVariable;

    public DslRegexExtractor(String variableName, String regex) {
        super("name", RegexExtractorGui.class);
        this.variableName = variableName;
        this.regex = regex;
    }

    public DslRegexExtractor matchNumber(int matchNumber) {
        this.matchNumber = matchNumber;
        return this;
    }

    public DslRegexExtractor template(String template) {
        this.template = template;
        return this;
    }

    public DslRegexExtractor defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DslRegexExtractor fieldToCheck(TargetField fieldToCheck) {
        this.fieldToCheck = fieldToCheck;
        return this;
    }

    public DslRegexExtractor scope(Scope scope) {
        this.scope = scope;
        return this;
    }

    public DslRegexExtractor scopeVariable(String scopeVariable) {
        this.scopeVariable = scopeVariable;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        RegexExtractor ret = new RegexExtractor();
        this.scope.applyTo(ret);
        if (this.scopeVariable != null) {
            ret.setScopeVariable(this.scopeVariable);
        }
        this.fieldToCheck.applyTo(ret);
        ret.setRefName(this.variableName);
        ret.setRegex(this.regex);
        ret.setMatchNumber(this.matchNumber);
        ret.setTemplate(this.template);
        if (this.defaultValue != null) {
            if (this.defaultValue.isEmpty()) {
                ret.setDefaultEmptyValue(true);
            } else {
                ret.setDefaultValue(this.defaultValue);
            }
        }
        return ret;
    }

    public static enum Scope {
        ALL_SAMPLES(AbstractScopedTestElement::setScopeAll),
        MAIN_SAMPLE(AbstractScopedTestElement::setScopeParent),
        SUB_SAMPLES(AbstractScopedTestElement::setScopeChildren);

        private final Consumer<RegexExtractor> applier;

        private Scope(Consumer<RegexExtractor> applier) {
            this.applier = applier;
        }

        private void applyTo(RegexExtractor re) {
            this.applier.accept(re);
        }
    }

    public static enum TargetField {
        RESPONSE_BODY(RegexExtractor::useBody),
        RESPONSE_BODY_UNESCAPED(RegexExtractor::useUnescapedBody),
        RESPONSE_BODY_AS_DOCUMENT(RegexExtractor::useBodyAsDocument),
        RESPONSE_HEADERS(RegexExtractor::useHeaders),
        REQUEST_HEADERS(RegexExtractor::useRequestHeaders),
        REQUEST_URL(RegexExtractor::useUrl),
        RESPONSE_CODE(RegexExtractor::useCode),
        RESPONSE_MESSAGE(RegexExtractor::useMessage);

        private final Consumer<RegexExtractor> applier;

        private TargetField(Consumer<RegexExtractor> applier) {
            this.applier = applier;
        }

        private void applyTo(RegexExtractor re) {
            this.applier.accept(re);
        }
    }
}

