/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.wrapper.wrappers;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.DoubleProperty;
import org.apache.jmeter.testelement.property.FloatProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.core.testelements.BaseTestElement;

public class TestElementWrapperCallBuilder<T extends TestElement>
extends SingleTestElementCallBuilder<T> {
    protected final Set<String> ignoredProperties = new HashSet<String>(Arrays.asList("TestElement.name", "TestElement.test_class", "TestElement.gui_class", "TestElement.enabled", "TestPlan.comments"));
    private final Class<? extends JMeterGUIComponent> guiClass;

    public TestElementWrapperCallBuilder(Class<T> testElementClass, Class<? extends JMeterGUIComponent> guiClass, List<Method> builderMethods) {
        super(testElementClass, builderMethods);
        this.guiClass = guiClass;
    }

    protected MethodCall buildMethodCall(T testElement, MethodCallContext context) {
        TestElement defaultInstance;
        ClassInstanceParam builderParam;
        try {
            if (testElement instanceof TestBean) {
                Class<?> constructorClass = testElement.getClass();
                builderParam = new ClassInstanceParam(this.testElementClass, constructorClass);
                defaultInstance = (TestElement)constructorClass.newInstance();
                BaseTestElement.loadBeanProperties((TestElement)defaultInstance);
            } else {
                String guiClassName = testElement.getPropertyAsString("TestElement.gui_class");
                Class<?> constructorClass = Class.forName(guiClassName);
                builderParam = new ClassInstanceParam(this.guiClass, constructorClass);
                JMeterGUIComponent guiComponent = (JMeterGUIComponent)constructorClass.newInstance();
                guiComponent.clearGui();
                defaultInstance = guiComponent.createTestElement();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        MethodCall ret = this.buildMethodCall(new MethodParam[]{new MethodParam.NameParam(testElement.getName(), defaultInstance.getName()), builderParam});
        TestElementWrapperCallBuilder.propIter2Stream(testElement.propertyIterator()).filter(p -> !this.isPropertyWithDefaultValue((JMeterProperty)p, (T)defaultInstance) && !this.ignoredProperties.contains(p.getName())).map(x$0 -> new PropertyParam((JMeterProperty)x$0)).filter(p -> !p.isDefault()).forEach(p -> ret.chain("prop", new MethodParam[]{new MethodParam.StringParam(((PropertyParam)p).getName()), p}));
        return ret;
    }

    private boolean isPropertyWithDefaultValue(JMeterProperty p, T defaultInstance) {
        return Objects.equals(p.getObjectValue(), defaultInstance.getProperty(p.getName()).getObjectValue());
    }

    private static Stream<JMeterProperty> propIter2Stream(PropertyIterator iter) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 0), false);
    }

    private static class ClassInstanceParam
    extends MethodParam {
        private final Class<?> constructorType;

        private ClassInstanceParam(Class<?> paramType, Class<?> constructorType) {
            super(paramType, null);
            this.constructorType = constructorType;
        }

        protected String buildCode(String indent) {
            return "new " + this.constructorType.getSimpleName() + "()";
        }
    }

    private static class PropertyParam
    extends MethodParam {
        private static final List<Class<? extends JMeterProperty>> LITERAL_PROPERTY_TYPES = Arrays.asList(NullProperty.class, BooleanProperty.class, IntegerProperty.class, LongProperty.class, FloatProperty.class, DoubleProperty.class);
        private final JMeterProperty prop;

        private PropertyParam(JMeterProperty prop) {
            super(Object.class, prop.getStringValue());
            this.prop = prop;
        }

        private String getName() {
            return this.prop.getName();
        }

        public boolean isDefault() {
            return super.isDefault() || this.prop instanceof CollectionProperty && ((CollectionProperty)this.prop).isEmpty();
        }

        protected String buildCode(String indent) {
            if (LITERAL_PROPERTY_TYPES.stream().anyMatch(pt -> pt.isInstance(this.prop))) {
                return this.prop.getStringValue();
            }
            if (this.prop instanceof CollectionProperty) {
                return this.buildCollectionCode((CollectionProperty)this.prop, indent);
            }
            return PropertyParam.buildStringLiteral((String)this.prop.getStringValue());
        }

        private String buildCollectionCode(CollectionProperty prop, String indent) {
            if (prop.size() == 1) {
                return "Collections.singletonList(" + new PropertyParam(prop.iterator().next()).buildCode(indent) + ")";
            }
            String childIndent = indent + "  ";
            return "Arrays.asList(\n" + childIndent + TestElementWrapperCallBuilder.propIter2Stream(prop.iterator()).map(p -> new PropertyParam((JMeterProperty)p).buildCode(childIndent)).collect(Collectors.joining(",\n" + childIndent)) + "\n" + indent + ")";
        }
    }
}

