/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Types;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.jmeter.protocol.jdbc.sampler.JDBCSampler;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.params.BoolParam;
import us.abstracta.jmeter.javadsl.codegeneration.params.EnumParam;
import us.abstracta.jmeter.javadsl.codegeneration.params.FixedParam;
import us.abstracta.jmeter.javadsl.codegeneration.params.StringArrayParam;
import us.abstracta.jmeter.javadsl.core.samplers.BaseSampler;

public class DslJdbcSampler
extends BaseSampler<DslJdbcSampler> {
    private static final String DEFAULT_NAME = "JDBC Request";
    private static final String NULL_ARGUMENT = "]NULL[";
    protected String poolName;
    protected String query;
    protected final List<QueryParameter> params = new ArrayList<QueryParameter>();
    protected final List<String> vars = new ArrayList<String>();
    protected String resultsVar;
    protected Duration timeout;
    protected QueryType queryType;

    public DslJdbcSampler(String name, String poolName, String query) {
        super(name != null ? name : DEFAULT_NAME, TestBeanGUI.class);
        this.poolName = poolName;
        this.query = query;
    }

    public DslJdbcSampler param(Object value, int jdbcParamType) {
        return this.param(value, jdbcParamType, JdbcParamMode.IN);
    }

    public DslJdbcSampler param(Object value, int jdbcParamType, JdbcParamMode mode) {
        this.params.add(new QueryParameter(value, jdbcParamType, mode));
        return this;
    }

    public DslJdbcSampler vars(String ... vars) {
        this.vars.addAll(Arrays.asList(vars));
        return this;
    }

    public DslJdbcSampler resultsVar(String resultsVar) {
        this.resultsVar = resultsVar;
        return this;
    }

    public DslJdbcSampler timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public DslJdbcSampler commit() {
        this.queryType = QueryType.COMMIT;
        return this;
    }

    public DslJdbcSampler rollback() {
        this.queryType = QueryType.ROLLBACK;
        return this;
    }

    public DslJdbcSampler autoCommit(boolean enabled) {
        this.queryType = enabled ? QueryType.AUTO_COMMIT_TRUE : QueryType.AUTO_COMMIT_FALSE;
        return this;
    }

    public DslJdbcSampler queryType(QueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    protected TestElement buildTestElement() {
        JDBCSampler ret = new JDBCSampler();
        ret.setQueryType(this.getQueryType().propertyValue);
        ret.setDataSource(this.poolName);
        ret.setQuery(this.query);
        ret.setQueryArguments(this.params.stream().map(this::extractParamValue).collect(Collectors.joining(",")));
        ret.setQueryArgumentsTypes(this.params.stream().map(rec$ -> ((QueryParameter)rec$).getTypePropertyValue()).collect(Collectors.joining(",")));
        ret.setVariableNames(String.join((CharSequence)",", this.vars));
        ret.setResultVariable(this.resultsVar);
        ret.setQueryTimeout(this.timeout != null ? String.valueOf(DslJdbcSampler.durationToSeconds((Duration)this.timeout)) : "-1");
        return ret;
    }

    private QueryType getQueryType() {
        if (this.queryType != null) {
            return this.queryType;
        }
        if (this.query == null) {
            throw new IllegalStateException("Query can only be null when using commit, rollback or autoCommit");
        }
        return DslJdbcSampler.solveQueryType(this.query, this.params.isEmpty());
    }

    private static QueryType solveQueryType(String query, boolean hasParams) {
        String queryType = query.trim();
        if (query.isEmpty()) {
            return null;
        }
        if ("select".equals(queryType = queryType.substring(0, queryType.indexOf(" ")).toLowerCase(Locale.US))) {
            return hasParams ? QueryType.SELECT : QueryType.PREPARED_SELECT;
        }
        if ("insert".equals(queryType) || "update".equals(queryType) || "delete".equals(queryType)) {
            return hasParams ? QueryType.UPDATE : QueryType.PREPARED_UPDATE;
        }
        return QueryType.CALLABLE;
    }

    private String extractParamValue(QueryParameter p) {
        if (p.value == null) {
            return NULL_ARGUMENT;
        }
        String strValue = p.value.toString();
        if (strValue.contains(",") || strValue.contains("\"")) {
            return "\"" + strValue.replace("\"", "\"\"") + "\"";
        }
        return strValue;
    }

    private static class ValueParam
    extends MethodParam {
        private static final Set<String> STRING_TYPES = new HashSet<String>(Arrays.asList("CHAR", "VARCHAR", "LONGVARCHAR", "NCHAR", "NVARCHAR", "LONGNVARCHAR"));
        private final ParsedArgumentType argumentType;

        private ValueParam(String expression, ParsedArgumentType argumentType) {
            super(Object.class, expression);
            this.argumentType = argumentType;
        }

        protected String buildCode(String indent) {
            return STRING_TYPES.contains(this.argumentType.paramType.type) ? ValueParam.buildStringLiteral((String)this.expression, (String)indent) : this.expression;
        }
    }

    private static class ArgumentTypeParam
    extends MethodParam {
        private static final Set<String> PREDEFINED_TYPES = ArgumentTypeParam.findConstantNames(Types.class, Integer.TYPE, f -> true);
        private final String type;

        protected ArgumentTypeParam(String expression) {
            super(Integer.TYPE, expression);
            this.type = expression.toUpperCase();
        }

        public boolean isDefault() {
            return this.expression == null;
        }

        public Set<String> getImports() {
            return PREDEFINED_TYPES.contains(this.type) ? Collections.singleton(Types.class.getName()) : Collections.emptySet();
        }

        protected String buildCode(String indent) {
            return PREDEFINED_TYPES.contains(this.type) ? "Types." + this.type : this.type;
        }
    }

    private static class ParsedArgumentType {
        private final EnumParam<JdbcParamMode> mode;
        private final ArgumentTypeParam paramType;

        private ParsedArgumentType(EnumParam<JdbcParamMode> mode, ArgumentTypeParam paramType) {
            this.mode = mode;
            this.paramType = paramType;
        }

        private static List<ParsedArgumentType> parseAll(String str) {
            if (str == null || str.isEmpty()) {
                return Collections.emptyList();
            }
            Pattern paramTypePattern = Pattern.compile("(?:(IN|OUT|INOUT) )?(-?\\w+)");
            return Arrays.stream(str.split(",")).map(s -> {
                Matcher paramTypeMatcher = paramTypePattern.matcher((CharSequence)s);
                paramTypeMatcher.find();
                return new ParsedArgumentType((EnumParam<JdbcParamMode>)new EnumParam(JdbcParamMode.class, paramTypeMatcher.group(1), (Enum)JdbcParamMode.IN), new ArgumentTypeParam(paramTypeMatcher.group(2)));
            }).collect(Collectors.toList());
        }
    }

    private static class QueryArgumentsParser {
        private final String queryArguments;
        private int pos = 0;

        private QueryArgumentsParser(String queryArguments) {
            this.queryArguments = queryArguments;
        }

        private ValueParam parseNext(ParsedArgumentType argumentType) {
            int finalPos;
            String ret;
            if (this.queryArguments.startsWith(DslJdbcSampler.NULL_ARGUMENT, this.pos)) {
                ret = null;
                finalPos = this.queryArguments.indexOf(this.pos, 44);
            } else if (this.queryArguments.charAt(this.pos) == '\"') {
                finalPos = this.findQuotedParamEnd();
                ret = this.queryArguments.substring(this.pos + 1, finalPos).replace("\"\"", "\"");
                finalPos = this.queryArguments.indexOf(44, finalPos);
            } else {
                finalPos = this.queryArguments.indexOf(44, this.pos);
                ret = this.queryArguments.substring(this.pos, finalPos == -1 ? this.queryArguments.length() : finalPos);
            }
            this.pos = finalPos + 1;
            return new ValueParam(ret, argumentType);
        }

        private int findQuotedParamEnd() {
            int finalPos = this.pos + 1;
            while (this.queryArguments.charAt(finalPos) != '\"' || finalPos + 1 < this.queryArguments.length() && this.queryArguments.charAt(finalPos + 1) == '\"') {
                if (this.queryArguments.charAt(finalPos) == '\"' && this.queryArguments.charAt(finalPos + 1) == '\"') {
                    ++finalPos;
                }
                ++finalPos;
            }
            return finalPos;
        }
    }

    public static class CodeBuilder
    extends SingleTestElementCallBuilder<JDBCSampler> {
        public CodeBuilder(List<Method> builderMethods) {
            super(JDBCSampler.class, builderMethods);
        }

        protected MethodCall buildMethodCall(JDBCSampler testElement, MethodCallContext context) {
            TestElementParamBuilder paramBuilder = new TestElementParamBuilder((TestElement)testElement);
            FixedParam queryType = (FixedParam)paramBuilder.enumParam("queryType", (Enum)QueryType.COMMIT);
            MethodParam query = paramBuilder.stringParam("query");
            String queryArgumentsTypes = testElement.getPropertyAsString("queryArgumentsTypes");
            MethodCall ret = this.buildMethodCall(new MethodParam[]{paramBuilder.nameParam(DslJdbcSampler.DEFAULT_NAME), paramBuilder.stringParam("dataSource"), query});
            if (queryType.getValue() == QueryType.COMMIT) {
                ret.chain("commit", new MethodParam[0]);
            } else if (queryType.getValue() == QueryType.ROLLBACK) {
                ret.chain("rollback", new MethodParam[0]);
            } else if (queryType.getValue() == QueryType.AUTO_COMMIT_TRUE || queryType.getValue() == QueryType.AUTO_COMMIT_FALSE) {
                ret.chain("autoCommit", new MethodParam[]{new BoolParam(Boolean.valueOf(queryType.getValue() == QueryType.AUTO_COMMIT_TRUE), null)});
            } else if (queryType.getValue() != DslJdbcSampler.solveQueryType(query.getExpression(), queryArgumentsTypes == null || queryArgumentsTypes.isEmpty())) {
                ret.chain("queryType", new MethodParam[]{queryType});
            } else {
                this.chainParams(ret, queryArgumentsTypes, testElement.getPropertyAsString("queryArguments"));
                ret.chain("vars", new MethodParam[]{new StringArrayParam(testElement.getPropertyAsString("variableNames"))}).chain("resultVar", new MethodParam[]{paramBuilder.stringParam("resultVariable")});
            }
            return ret.chain("timeout", new MethodParam[]{paramBuilder.durationParam("queryTimeout", Duration.ofSeconds(-1L))});
        }

        private void chainParams(MethodCall ret, String queryArgumentsTypes, String queryArguments) {
            if (queryArgumentsTypes == null || queryArgumentsTypes.isEmpty()) {
                return;
            }
            QueryArgumentsParser argumentParser = new QueryArgumentsParser(queryArguments);
            for (ParsedArgumentType argumentType : ParsedArgumentType.parseAll(queryArgumentsTypes)) {
                ValueParam value = argumentParser.parseNext(argumentType);
                if (argumentType.mode.isDefault()) {
                    ret.chain("param", new MethodParam[]{value, argumentType.paramType});
                    continue;
                }
                ret.chain("param", new MethodParam[]{value, argumentType.paramType, argumentType.mode});
            }
        }
    }

    public static enum QueryType implements EnumParam.EnumPropertyValue
    {
        SELECT("Select Statement"),
        UPDATE("Update Statement"),
        CALLABLE("Callable Statement"),
        PREPARED_SELECT("Prepared Select Statement"),
        PREPARED_UPDATE("Prepared Update Statement"),
        COMMIT("Commit"),
        ROLLBACK("Rollback"),
        AUTO_COMMIT_FALSE("AutoCommit(false)"),
        AUTO_COMMIT_TRUE("AutoCommit(true)");

        private final String propertyValue;

        private QueryType(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String propertyValue() {
            return this.propertyValue;
        }
    }

    public static enum JdbcParamMode implements EnumParam.EnumPropertyValue
    {
        IN,
        OUT,
        INOUT;


        public String propertyValue() {
            return this.name();
        }
    }

    protected static class QueryParameter {
        private static final Map<Integer, String> JDBC_TYPE_TO_PROPERTY_VALUE = QueryParameter.buildJdbcTypeToPropertyValueMapping();
        public final Object value;
        public final int jdbcType;
        public final JdbcParamMode mode;

        private QueryParameter(Object value, int jdbcType, JdbcParamMode mode) {
            this.value = value;
            this.jdbcType = jdbcType;
            this.mode = mode;
        }

        private static Map<Integer, String> buildJdbcTypeToPropertyValueMapping() {
            HashMap<Integer, String> ret = new HashMap<Integer, String>();
            Field[] fields = Types.class.getFields();
            try {
                for (Field field : fields) {
                    String name = field.getName();
                    Integer value = (Integer)field.get(null);
                    ret.put(value, name.toLowerCase(Locale.ENGLISH));
                }
                return ret;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private String getTypePropertyValue() {
            String propVal = JDBC_TYPE_TO_PROPERTY_VALUE.get(this.jdbcType);
            if (propVal == null) {
                propVal = String.valueOf(this.jdbcType);
            }
            return this.mode == JdbcParamMode.IN ? propVal : this.mode.name() + " " + propVal;
        }
    }
}

