/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.blazemeter;

import java.util.List;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunRequestStats;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunSummaryStats;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.stats.CountMetricSummary;
import us.abstracta.jmeter.javadsl.engines.BaseRemoteEngineStatsSummary;
import us.abstracta.jmeter.javadsl.engines.RemoteEngineTimeMetricSummary;

public class BlazeMeterTestPlanStats
extends TestPlanStats {
    public BlazeMeterTestPlanStats(TestRunSummaryStats.TestRunLabeledSummary summary, List<TestRunRequestStats> labeledStats) {
        super(() -> null);
        for (TestRunRequestStats labeledStat : labeledStats) {
            BlazemeterStatsSummary labelStatsSummary = new BlazemeterStatsSummary(labeledStat, summary);
            if ("ALL".equals(labeledStat.getLabelName())) {
                this.overallStats = labelStatsSummary;
                this.setStart(labelStatsSummary.firstTime());
                this.setEnd(labelStatsSummary.endTime());
                continue;
            }
            this.labeledStats.put(labeledStat.getLabelName(), labelStatsSummary);
        }
    }

    private static class BlazeMeterTimeMetricSummary
    extends RemoteEngineTimeMetricSummary {
        private BlazeMeterTimeMetricSummary(long min, long max, double mean, double median, double percentile90, double percentile95, double percentile99) {
            super(min, max, mean, median, percentile90, percentile95, percentile99);
        }
    }

    private static class BlazemeterStatsSummary
    extends BaseRemoteEngineStatsSummary {
        private BlazemeterStatsSummary(TestRunRequestStats labeledStat, TestRunSummaryStats.TestRunLabeledSummary summary) {
            super(summary.getFirst(), summary.getLast(), labeledStat.getDuration(), labeledStat.getSamples(), labeledStat.getErrorsCount(), labeledStat.getMinResponseTime(), labeledStat.getMaxResponseTime(), labeledStat.getAvgResponseTime(), (double)labeledStat.getMedianResponseTime(), (double)labeledStat.getPerc90(), (double)labeledStat.getPerc95(), (double)labeledStat.getPerc99(), labeledStat.getAvgBytes(), 0.0);
        }

        public CountMetricSummary sentBytes() {
            throw new UnsupportedOperationException("BlazeMeter API does not provide an efficient way to get this value.");
        }
    }
}

